package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalPartRespReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalPartRespReportFilterType;
import gov.va.med.cds.exception.PersistenceException;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;

import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.hibernate.Query;
import org.hibernate.Session;

public class CensusRrTotalPartRespRportPersistenceManager extends AbstractReadableReportsPersistenceManager 
	implements ReadableReportsPersistenceManagerInterface {
	
	protected String censusRrTotalPartRespRportQuery;
		
	@Override
	public HTResponseType performReadReportAggregate(
			HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
		
		RRTotalPartRespReportFilterType filter = aReportFilter.getRRTotalPartRespReportFilter();

		XMLGregorianCalendar xmlStartDate = filter.getStartDate();
		XMLGregorianCalendar xmlEndDate = filter.getEndDate();
		
		java.sql.Date sqlStartDate = formatDate(xmlStartDate);
		java.sql.Date sqlEndDate = formatDate(xmlEndDate);
		Session aSession = this.sessionFactory.getCurrentSession();
		
		List<CensusPatientCountDataType> results = null;
		
		try {
			Query query = aSession.getNamedQuery( censusRrTotalPartRespRportQuery );
			
				String location  = filter.getGeographicalArea().getLocation();
				String vendor = filter.getVendor();
			    query.setDate("startDate", sqlStartDate);
			    query.setDate("endDate", sqlEndDate);
			    query.setString( "geographicalArea", location );
			    query.setString( "vendor", vendor );
			
			    if ( LOGGER.isDebugEnabled() )
			    {
			        LOGGER.debug("========== Calling CensusRRTotalPartRespRportQuery query procedure: " + censusRrTotalPartRespRportQuery + " ======"  );
			        LOGGER.debug( " CensusRRTotalPartRespRport   startDate: '" + sqlStartDate  + "'");
			        LOGGER.debug( " CensusRRTotalPartRespRport   endDate: '" + sqlEndDate + "'");
			        LOGGER.debug( " CensusRRTotalPartRespRport   geographicalArea location: '" + location + "'");
			        LOGGER.debug( " CensusRRTotalPartRespRport   vendor: '" + vendor + "'");
			    }
			    
			     results = (List<CensusPatientCountDataType>)queryForReportData(query);			    
		} finally{ 
			if( aSession != null){
				aSession.close();
			}
		}
		
		List <GeographicalAreaVendorPatientCountDataType>  listData = null;
		listData =  CensusTransformData.transformDataProcess(results);
		RRTotalPartRespReportDataType data = new RRTotalPartRespReportDataType();
		data.getGeographicalAreaData().addAll(listData);
		data.setReportID(filter.getReportID());
	
	    responseType.setRRTotalPartRespReportData(data);
		
		return responseType;
		
	}

	public void setcensusRrTotalPartRespRportQuery(
			String acensusRrTotalPartRespRportQuery){
		this.censusRrTotalPartRespRportQuery = acensusRrTotalPartRespRportQuery;
	}

}
