package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.COCTotalPtL2ReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.COCTotalPtL2ReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;

import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.hibernate.Query;
import org.hibernate.Session;

public class CensusCoCTotalPtL2ReportPersistenceManager extends AbstractReadableReportsPersistenceManager 
	implements ReadableReportsPersistenceManagerInterface {
	
	protected String censusCoCTotalPtL2ReportQuery;
		
	@Override
	public HTResponseType performReadReportAggregate(
			HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
		
		COCTotalPtL2ReportFilterType filter = aReportFilter.getCoCTotalPtL2ReportFilter();

		XMLGregorianCalendar xmlStartDate = filter.getStartDate();
		XMLGregorianCalendar xmlEndDate = filter.getEndDate();
		
		java.sql.Date sqlStartDate = formatDate(xmlStartDate);
		java.sql.Date sqlEndDate = formatDate(xmlEndDate);
		Session aSession = this.sessionFactory.getCurrentSession();
		
		List<CensusPatientCountDataType> results = null;
		
		try {
			Query query = aSession.getNamedQuery( censusCoCTotalPtL2ReportQuery );
			
				String location  = filter.getGeographicalArea().getLocation();
				String vendor = filter.getVendor();
			    query.setDate("startDate", sqlStartDate);
			    query.setDate("endDate", sqlEndDate);
			    query.setString( "geographicalArea", location );
			    query.setString( "vendor", vendor );
			
			    if ( LOGGER.isDebugEnabled() )
			    {
			        LOGGER.debug("========== Calling CensusCoCTotalPtL2Report query procedure: " + censusCoCTotalPtL2ReportQuery + " ======"  );
			        LOGGER.debug( " CensusCoCTotalPtL2Report   startDate: '" + sqlStartDate  + "'");
			        LOGGER.debug( " CensusCoCTotalPtL2Report   endDate: '" + sqlEndDate + "'");
			        LOGGER.debug( " CensusCoCTotalPtL2Report   geographicalArea location: '" + location + "'");
			        LOGGER.debug( " CensusCoCTotalPtL2Report   vendor: '" + vendor + "'");
			    }
			    
			     results = (List<CensusPatientCountDataType>)queryForReportData(query);			    
		} finally{ 
			if( aSession != null){
				aSession.close();
			}
		}
		
		List <GeographicalAreaVendorPatientCountDataType>  listData = null;
		listData =  CensusTransformData.transformDataProcess(results);
		COCTotalPtL2ReportDataType data = new COCTotalPtL2ReportDataType();
		data.getGeographicalAreaData().addAll(listData);
		data.setReportID(filter.getReportID());
	
	    responseType.setCoCTotalPtL2ReportData(data);
		
		return responseType;
		
	}

	public void setcensusCoCTotalPtL2ReportQuery(
			String acensusCoCTotalPtL2ReportQuery){
		this.censusCoCTotalPtL2ReportQuery = acensusCoCTotalPtL2ReportQuery;
	}

}
