

package gov.va.med.cds.ars;


import javax.ejb.Remote;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;
import javax.jws.soap.SOAPBinding.Style;
import javax.jws.soap.SOAPBinding.Use;


/**
 * Service Endpoint Interface (SEI)
 */

@Remote	
@WebService		  
@SOAPBinding( style = Style.DOCUMENT, 
        use   = Use.LITERAL,
        parameterStyle = ParameterStyle.WRAPPED )
public interface AggregateReportingServiceInterface
{
    /**
     * Check to see if system is running
     *
     * @return true if the system is running.
     */
    @WebMethod
    boolean isAlive( );
    
    /**
     * Synchronous version of a clinical data read
     *
     * @param reportRequest Filter request specified in xml format according to the CDS filter schema
     * @param reportId ID of the named (canned) filter. 
     * @param requestId Client specified unique request Id
     * @return Results of the read returned in XML according to the CDS read results schema
     */
    @WebMethod( operationName = "readAggregateData" )
    String readAggregateData( 	@WebParam( name = "reportRequest" ) String reportRequest, 
    							@WebParam( name = "reportId" ) String reportId, 
    							@WebParam( name = "clientId" ) String clientId,
    							@WebParam( name = "requestId" ) String requestId );
}
