/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.saml;

import gov.va.med.cds.saml.SamlAssertionThreadLocal;
import gov.va.med.cds.saml.SamlAssertionXml;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.DOM2Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapSamlHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String SAML_NS = "urn:oasis:names:tc:SAML:1.0:assertion";
    public static final String SAML2_NS = "urn:oasis:names:tc:SAML:2.0:assertion";

    public Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext mc) {
    }

    public boolean handleFault(SOAPMessageContext mc) {
        return true;
    }

    public boolean handleMessage(SOAPMessageContext mc) {
        if (Boolean.FALSE.equals(mc.get((Object)"javax.xml.ws.handler.message.outbound"))) {
            try {
                Element child;
                SOAPHeader sh = mc.getMessage().getSOAPHeader();
                Node securityElement = sh.getFirstChild();
                if (securityElement != null && (child = SoapSamlHandler.getFirstElement(securityElement)) != null && "Assertion".equals(child.getLocalName()) && (SAML_NS.equals(child.getNamespaceURI()) || SAML2_NS.equals(child.getNamespaceURI()))) {
                    String samlXML = SoapSamlHandler.assertionToString(child);
                    SamlAssertionThreadLocal.set((SamlAssertionXml)new SamlAssertionXml(samlXML));
                }
            }
            catch (SOAPException se) {
                throw new ProtocolException((Throwable)se);
            }
            catch (Exception e) {
                throw new ProtocolException((Throwable)e);
            }
        }
        return true;
    }

    protected static Element getFirstElement(Node parent) {
        Node n;
        for (n = parent.getFirstChild(); n != null && 1 != n.getNodeType(); n = n.getNextSibling()) {
        }
        if (n == null) {
            return null;
        }
        return (Element)n;
    }

    protected static String assertionToString(Element assertionElement) throws WSSecurityException {
        String assertion = "";
        if (assertionElement != null) {
            assertion = DOM2Writer.nodeToString((Node)assertionElement);
        }
        return assertion;
    }
}

