/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.UserType;

public class XmlDateOnlyUserType
implements UserType {
    private int[] types = new int[]{91};
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    public int[] sqlTypes() {
        return this.types;
    }

    public Class returnedClass() {
        return XMLGregorianCalendar.class;
    }

    public boolean equals(Object a, Object b) throws HibernateException {
        return a == b || a != null && b != null && a.equals(b);
    }

    public int hashCode(Object o) throws HibernateException {
        return o.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        String strDate = rs.getString(names[0]);
        Date date = null;
        XMLGregorianCalendar returnDate = null;
        try {
            date = formatter.parse(strDate);
        }
        catch (ParseException e) {
            throw new IllegalStateException("XmlDateOnlyUserType nullSafeGet date parse failure : " + strDate);
        }
        java.sql.Date databaseDate = new java.sql.Date(date.getTime());
        returnDate = XmlDateOnlyUserType.asXMLGregorianCalendar(databaseDate);
        return returnDate;
    }

    public void nullSafeSet(PreparedStatement ps, Object value, int index, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        throw new IllegalStateException("nullSafeSet not implemented for usertype XmlDateUserType.");
    }

    public Object deepCopy(Object o) throws HibernateException {
        java.sql.Date returnDate = null;
        if (o instanceof java.sql.Date) {
            returnDate = new java.sql.Date(((java.sql.Date)o).getTime());
        }
        return returnDate;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public static XMLGregorianCalendar asXMLGregorianCalendar(java.sql.Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(date.getTime());
        XMLGregorianCalendar xmlDate = null;
        try {
            xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendarDate(cal.get(1), cal.get(2) + 1, cal.get(5), Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException("Error in XML Date conversion : " + e);
        }
        return xmlDate;
    }
}

