/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.VendorReportPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.CensusVendorReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.ObjectFactory;
import gov.va.med.cds.ars.requestresponse.generated.VendorReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.VendorReportFilterType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class VendorReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements VendorReportPersistenceManagerInterface {
    protected String vendorQuery = "SurveyReports.Vendor";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        ObjectFactory objectFactory = new ObjectFactory();
        VendorReportDataType data = objectFactory.createVendorReportDataType();
        VendorReportDataType.Vendors vendor = objectFactory.createVendorReportDataTypeVendors();
        data.setVendors(vendor);
        VendorReportFilterType filter = aReportFilter.getVendorReportFilter();
        try (Session session = this.sessionFactory.getCurrentSession();){
            List<CensusVendorReportDataType> results = null;
            results = this.vendorReport(session, filter);
            data.getVendors().getVendor().addAll(results);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setVendorReportData(data);
        return this.responseType;
    }

    private List<CensusVendorReportDataType> vendorReport(Session aSession, VendorReportFilterType aVendorReportFilterType) throws PersistenceException {
        Query query = aSession.getNamedQuery(this.vendorQuery);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling Census Vendor Repot stored proc: *****(  " + this.vendorQuery + "  )*****"));
        }
        List results = this.queryForReportData(query);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"----- Done with Census Vendor Report stored proc");
        }
        return results;
    }

    public void setVendorQuery(String aVendorQuery) {
        this.vendorQuery = aVendorQuery;
    }
}

