/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.HTBaseGeographicalAreaDateReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTBaseReportType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.PSLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.PSReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.PSReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.PsSurveyQuestionType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

public class SatisfactionReportsPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String satisfactionQuery = "SurveyReports.patientSatisfaction";
    protected String acceptedSurveyCountQuery = "SurveyReports.countSurveys";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        PSReportFilterType filter = aReportFilter.getPatientSatisfactionReportFilter();
        PSReportDataType data = new PSReportDataType();
        try (Session session = this.sessionFactory.getCurrentSession();){
            List<PSLocationReportDataType> results = null;
            Integer surveyCount = null;
            results = this.patientSatisfactionReport(session, filter);
            surveyCount = this.getAcceptedSurveyCount(session, filter);
            data.getReportData().addAll(results);
            data.setNumberOfRecordsConsidered(surveyCount);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setPatientSatisfactionReportData(data);
        return this.responseType;
    }

    private List<PSLocationReportDataType> patientSatisfactionReport(Session aSession, PSReportFilterType aPSReportFilter) throws PersistenceException {
        StringBuilder questions = new StringBuilder();
        PSReportFilterType.ReportQuestions reportQuestions = aPSReportFilter.getReportQuestions();
        if (reportQuestions == null) {
            questions.append("1,2,3,4,5,6,7,8");
        } else {
            List<PsSurveyQuestionType> questionList = reportQuestions.getReportQuestion();
            for (PsSurveyQuestionType psSurveyQuestionType : questionList) {
                questions.append(psSurveyQuestionType.getPsQuestionNumber());
                questions.append(",");
            }
            questions.deleteCharAt(questions.length() - 1);
        }
        String surveyVersion = aPSReportFilter.getSurveyVersion();
        String location = aPSReportFilter.getGeographicalArea().getLocation();
        java.sql.Date startDate = this.formatDate(aPSReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(aPSReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.satisfactionQuery);
        query.setString("surveyVersion", surveyVersion);
        query.setString("questions", questions.toString());
        query.setString("location", location);
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling Patient Satisfaction stored proc: *****(  " + this.satisfactionQuery + "  )*****"));
            LOGGER.debug((Object)(" version: " + surveyVersion));
            LOGGER.debug((Object)(" questions: " + questions));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = this.queryForReportData(query);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"----- Done with Patient Statisfaction stored proc");
        }
        return results;
    }

    protected Integer getAcceptedSurveyCount(Session aSession, HTBaseGeographicalAreaDateReportFilterType aReportFilter) {
        String surveyVersion = aReportFilter.getSurveyVersion();
        String surveyType = aReportFilter.getSurveyType() == null ? null : aReportFilter.getSurveyType().value();
        String location = aReportFilter.getGeographicalArea().getLocation();
        java.sql.Date startDate = this.formatDate(aReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(aReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.acceptedSurveyCountQuery);
        query.setString("surveyVersion", surveyVersion);
        query.setString("surveyType", surveyType);
        query.setString("location", location);
        query.setString("acceptedStatus", "ACCEPTED");
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling Count Surveys stored proc: *****(  " + this.acceptedSurveyCountQuery + "  )*****"));
            LOGGER.debug((Object)(" surveyVersion: " + surveyVersion));
            LOGGER.debug((Object)(" surveyType: " + surveyType));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)" acceptedStatus: ACCEPTED");
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = null;
        Integer count = null;
        try {
            results = query.list();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Count result size: " + results.size()));
            }
            if (results != null && results.size() > 0 && results.get(0) instanceof HTBaseReportType) {
                count = ((HTBaseReportType)results.get(0)).getNumberOfRecordsConsidered();
            }
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw e;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"----- Done with Count Surveys stored proc");
        }
        return count;
    }

    public void setSatisfactionQuery(String aSatisfactionQuery) {
        this.satisfactionQuery = aSatisfactionQuery;
    }

    public void setAcceptedSurveyCountQuery(String aAcceptedSurveyCountQuery) {
        this.acceptedSurveyCountQuery = aAcceptedSurveyCountQuery;
    }
}

