/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.HTBaseReportType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportSurveyType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.NationalDistributionLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.NationalDistributionReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.NationalDistributionReportFilterType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

public class NationalDistributionReportsPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String nationalDistributionQuery = "SurveyReports.nationalDistribution";
    protected String acceptedSurveyCountQuery = "SurveyReports.countSurveysNationalDist";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        NationalDistributionReportFilterType filter = aReportFilter.getNationalDistributionReportFilter();
        NationalDistributionReportDataType data = new NationalDistributionReportDataType();
        Session session = this.sessionFactory.getCurrentSession();
        HTReportSurveyType requestSurveyType = filter.getSurveyType();
        String surveyVersion = filter.getSurveyVersion();
        try {
            List<NationalDistributionLocationReportDataType> results = null;
            Integer surveyCount = null;
            Integer totalCount = null;
            filter = aReportFilter.getNationalDistributionReportFilter();
            filter.setSurveyVersion("All Versions");
            filter.setSurveyType(HTReportSurveyType.ALL_SURVEYS);
            results = this.nationalDistributionReport(session, filter);
            data.getReportData().addAll(results);
            filter.setSurveyType(HTReportSurveyType.VR_12_ADL);
            surveyCount = this.getAcceptedSurveyCount(session, filter);
            data.setNumberOfVR12Records(surveyCount);
            totalCount = surveyCount;
            filter.setSurveyType(HTReportSurveyType.PATIENT_SATISFACTION);
            surveyCount = this.getAcceptedSurveyCount(session, filter);
            data.setNumberOfPatientSatisfactionRecords(surveyCount);
            totalCount = totalCount + surveyCount;
            data.setNumberOfRecordsConsidered(totalCount);
            data.setReportID(filter.getReportID());
            filter.setSurveyType(requestSurveyType);
            filter.setSurveyVersion(surveyVersion);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" result of national distribution report: " + data));
            }
        }
        finally {
            session.close();
        }
        this.responseType.setNationalDistributionReportData(data);
        return this.responseType;
    }

    private List<NationalDistributionLocationReportDataType> nationalDistributionReport(Session aSession, NationalDistributionReportFilterType aNationalDistributionReportFilter) throws PersistenceException {
        String surveyVersion = aNationalDistributionReportFilter.getSurveyVersion();
        String surveyType = aNationalDistributionReportFilter.getSurveyType().value();
        Query query = aSession.getNamedQuery(this.nationalDistributionQuery);
        query.setString("surveyVersion", surveyVersion);
        query.setString("surveyType", surveyType);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling National Distribution stored proc: *****(  " + this.nationalDistributionQuery + "  )*****"));
            LOGGER.debug((Object)(" surveyVersion: " + surveyVersion));
            LOGGER.debug((Object)(" surveyType: " + surveyType));
        }
        List results = this.queryForReportData(query);
        if (LOGGER.isDebugEnabled()) {
            System.out.println("----- Done with National Distribution stored proc");
        }
        return results;
    }

    protected Integer getAcceptedSurveyCount(Session aSession, NationalDistributionReportFilterType aReportFilter) {
        String surveyVersion = aReportFilter.getSurveyVersion();
        String surveyType = aReportFilter.getSurveyType() == null ? null : aReportFilter.getSurveyType().value();
        Query query = aSession.getNamedQuery(this.acceptedSurveyCountQuery);
        query.setString("surveyVersion", surveyVersion);
        query.setString("surveyType", surveyType);
        query.setString("acceptedStatus", "ACCEPTED");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling Count Surveys stored proc: *****(  " + this.acceptedSurveyCountQuery + "  )*****"));
            LOGGER.debug((Object)(" surveyVersion: " + surveyVersion));
            LOGGER.debug((Object)(" surveyType: " + surveyType));
            LOGGER.debug((Object)" acceptedStatus: ACCEPTED");
        }
        List results = null;
        Integer count = null;
        try {
            results = query.list();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Count result size: " + results.size()));
            }
            if (results != null && results.size() > 0 && results.get(0) instanceof HTBaseReportType) {
                count = ((HTBaseReportType)results.get(0)).getNumberOfRecordsConsidered();
            }
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw e;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"----- Done with Count Surveys stored proc");
        }
        return count;
    }

    public void setNationalDistributionQuery(String aNationalDistributionQuery) {
        this.nationalDistributionQuery = aNationalDistributionQuery;
    }

    public void setAcceptedSurveyCountQuery(String aAcceptedSurveyCountQuery) {
        this.acceptedSurveyCountQuery = aAcceptedSurveyCountQuery;
    }
}

