/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.FYQtrReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.HTHFYQtrReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.HTHFYQtrReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class HthFiscalYearQuarterReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    private String hthQtrYearDataQuery = "CensusReports.hthFYQtrReport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        HTHFYQtrReportFilterType filter = aReportFilter.getHthFYQtrReportFilter();
        HTHFYQtrReportDataType data = new HTHFYQtrReportDataType();
        List<FYQtrReportDataType> results = null;
        try (Session session = this.sessionFactory.getCurrentSession();){
            results = this.getHthFYQuarterData(session, filter);
            data.getReportData().addAll(results);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setHthFYQtrReportData(data);
        return this.responseType;
    }

    private List<FYQtrReportDataType> getHthFYQuarterData(Session aSession, HTHFYQtrReportFilterType hthReportFilter) throws PersistenceException {
        Query query = aSession.getNamedQuery(this.hthQtrYearDataQuery);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling stored proc: *****(  " + this.hthQtrYearDataQuery + "  )*****"));
        }
        ArrayList<FYQtrReportDataType> results = new ArrayList();
        try {
            results = this.queryForReportData(query);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getHthFYQuarterData " + e));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("----- Done with stored proc " + this.hthQtrYearDataQuery));
        }
        return results;
    }

    public void setHthQtrYearDataQuery(String hthQtrYearDataQuery) {
        this.hthQtrYearDataQuery = hthQtrYearDataQuery;
    }
}

