/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.DistributionLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.DistributionReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.DistributionReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class DistributionReportsPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String distributionQuery = "SurveyReports.distribution";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        DistributionReportFilterType filter = aReportFilter.getDistributionReportFilter();
        DistributionReportDataType data = new DistributionReportDataType();
        try (Session session = this.sessionFactory.getCurrentSession();){
            List<DistributionLocationReportDataType> results = null;
            Integer surveyCount = null;
            results = this.distributionReport(session, filter);
            surveyCount = this.getSurveyCount(results);
            data.getReportData().addAll(results);
            data.setNumberOfRecordsConsidered(surveyCount);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setDistributionReportData(data);
        return this.responseType;
    }

    private List<DistributionLocationReportDataType> distributionReport(Session aSession, DistributionReportFilterType aDistributionReportFilter) throws PersistenceException {
        String surveyType = aDistributionReportFilter.getSurveyType() == null ? null : aDistributionReportFilter.getSurveyType().value();
        String location = aDistributionReportFilter.getGeographicalArea().getLocation();
        java.sql.Date startDate = this.formatDate(aDistributionReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(aDistributionReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.distributionQuery);
        query.setString("surveyType", surveyType);
        query.setString("location", location);
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling Distribution stored proc: *****(  " + this.distributionQuery + "  )*****"));
            LOGGER.debug((Object)(" surveyType: " + surveyType));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = this.queryForReportData(query);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"----- Done with Distribution stored proc");
        }
        return results;
    }

    public void setDistributionQuery(String aDistributionQuery) {
        this.distributionQuery = aDistributionQuery;
    }
}

