/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.DMPUniqueICNReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.DMPUniqueICNReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.LocationReportDataType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class DMPUniqueICNReportsPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String countDMPsUniqueICNQuery = "SurveyReports.countDMPsUniqueICN";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        DMPUniqueICNReportFilterType filter = aReportFilter.getDMPUniqueICNReportFilter();
        DMPUniqueICNReportDataType data = new DMPUniqueICNReportDataType();
        try (Session session = this.sessionFactory.getCurrentSession();){
            List<LocationReportDataType> results = null;
            Integer surveyCount = null;
            results = this.dmpUniqueIcnReport(session, filter);
            surveyCount = this.getSurveyCount(results);
            data.getReportData().addAll(results);
            data.setNumberOfRecordsConsidered(surveyCount);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setDMPUniqueICNReportData(data);
        return this.responseType;
    }

    private List<LocationReportDataType> dmpUniqueIcnReport(Session aSession, DMPUniqueICNReportFilterType aDMPReportFilter) throws PersistenceException {
        String surveyType = aDMPReportFilter.getSurveyType();
        String location = aDMPReportFilter.getGeographicalArea().getLocation();
        String vendor = aDMPReportFilter.getVendor();
        java.sql.Date startDate = this.formatDate(aDMPReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(aDMPReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.countDMPsUniqueICNQuery);
        query.setString("surveyType", surveyType);
        query.setString("location", location);
        query.setString("vendor", vendor);
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling DMP Unique ICN stored proc: *****(  " + this.countDMPsUniqueICNQuery + "  )*****"));
            LOGGER.debug((Object)(" surveyType: " + surveyType));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)(" vendor: " + vendor));
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = this.queryForReportData(query);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"----- Done with DMP Unique ICN stored proc");
        }
        return results;
    }

    public void setCountDMPsUniqueICNQuery(String aCountDMPsUniqueICNQuery) {
        this.countDMPsUniqueICNQuery = aCountDMPsUniqueICNQuery;
    }
}

