/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.CensusUnknownFacilityADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUnknownFacilityADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUnknownFacilityADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusUnknownFacilityADCReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String hthUnknownFacilityADCDataQuery = "SurveyReports.UnknownfacilityAdcReport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        CensusUnknownFacilityADCReportFilterType filter = aReportFilter.getCensusUnknownFacilityADCReportFilter();
        CensusUnknownFacilityADCReportDataType data = new CensusUnknownFacilityADCReportDataType();
        List<CensusUnknownFacilityADCLocationReportDataType> results = null;
        try (Session session = this.sessionFactory.getCurrentSession();){
            results = this.getUnknownFacilityADCData(session, filter);
            data.getReportData().addAll(results);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setCensusUnknownFacilityADCReportData(data);
        return this.responseType;
    }

    private List<CensusUnknownFacilityADCLocationReportDataType> getUnknownFacilityADCData(Session aSession, CensusUnknownFacilityADCReportFilterType censusReportFilter) throws PersistenceException {
        String location = censusReportFilter.getGeographicalArea().getLocation();
        java.sql.Date startDate = this.formatDate(censusReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(censusReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.hthUnknownFacilityADCDataQuery);
        query.setString("location", location);
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling stored proc: *****(  " + this.hthUnknownFacilityADCDataQuery + "  )*****"));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = null;
        try {
            results = this.queryForReportData(query);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getUnknownFacilityADCData " + e));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("----- Done with stored proc " + this.hthUnknownFacilityADCDataQuery));
        }
        return results;
    }

    public void setHthUnknownFacilityADCDataQuery(String hthUnknownFacilityADCDataQuery) {
        this.hthUnknownFacilityADCDataQuery = hthUnknownFacilityADCDataQuery;
    }
}

