/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.CensusRuralFacilityADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusRuralFacilityADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusRuralFacilityADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusRuralFacilityADCReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String hthRuralFacilityADCDataQuery = "SurveyReports.RuralfacilityAdcReport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        CensusRuralFacilityADCReportFilterType filter = aReportFilter.getCensusRuralFacilityADCReportFilter();
        CensusRuralFacilityADCReportDataType data = new CensusRuralFacilityADCReportDataType();
        List<CensusRuralFacilityADCLocationReportDataType> results = null;
        try (Session session = this.sessionFactory.getCurrentSession();){
            results = this.getRuralFacilityADCData(session, filter);
            data.getReportData().addAll(results);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setCensusRuralFacilityADCReportData(data);
        return this.responseType;
    }

    private List<CensusRuralFacilityADCLocationReportDataType> getRuralFacilityADCData(Session aSession, CensusRuralFacilityADCReportFilterType censusReportFilter) throws PersistenceException {
        String location = censusReportFilter.getGeographicalArea().getLocation();
        java.sql.Date startDate = this.formatDate(censusReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(censusReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.hthRuralFacilityADCDataQuery);
        query.setString("location", location);
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling stored proc: *****(  " + this.hthRuralFacilityADCDataQuery + "  )*****"));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = null;
        try {
            results = this.queryForReportData(query);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getRuralFacilityADCData " + e));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("----- Done with stored proc " + this.hthRuralFacilityADCDataQuery));
        }
        return results;
    }

    public void setHthRuralFacilityADCDataQuery(String hthRuralFacilityADCDataQuery) {
        this.hthRuralFacilityADCDataQuery = hthRuralFacilityADCDataQuery;
    }
}

