/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.CensusTransformData;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalNonRespReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalNonRespReportFilterType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusRrTotalNonRespRportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String censusRrTotalNonRespRportQuery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
        RRTotalNonRespReportFilterType filter = aReportFilter.getRRTotalNonRespReportFilter();
        XMLGregorianCalendar xmlStartDate = filter.getStartDate();
        XMLGregorianCalendar xmlEndDate = filter.getEndDate();
        java.sql.Date sqlStartDate = this.formatDate(xmlStartDate);
        java.sql.Date sqlEndDate = this.formatDate(xmlEndDate);
        List results = null;
        try (Session aSession = this.sessionFactory.getCurrentSession();){
            Query query = aSession.getNamedQuery(this.censusRrTotalNonRespRportQuery);
            String location = filter.getGeographicalArea().getLocation();
            String vendor = filter.getVendor();
            query.setDate("startDate", (Date)sqlStartDate);
            query.setDate("endDate", (Date)sqlEndDate);
            query.setString("geographicalArea", location);
            query.setString("vendor", vendor);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("========== Calling CensusRRTotalNonRespRportQuery query procedure: " + this.censusRrTotalNonRespRportQuery + " ======"));
                LOGGER.debug((Object)(" CensusRRTotalNonRespRport   startDate: '" + sqlStartDate + "'"));
                LOGGER.debug((Object)(" CensusRRTotalNonRespRport   endDate: '" + sqlEndDate + "'"));
                LOGGER.debug((Object)(" CensusRRTotalNonRespRport   geographicalArea location: '" + location + "'"));
                LOGGER.debug((Object)(" CensusRRTotalNonRespRport   vendor: '" + vendor + "'"));
            }
            results = this.queryForReportData(query);
        }
        List<GeographicalAreaVendorPatientCountDataType> listData = null;
        listData = CensusTransformData.transformDataProcess(results);
        RRTotalNonRespReportDataType data = new RRTotalNonRespReportDataType();
        data.getGeographicalAreaData().addAll(listData);
        data.setReportID(filter.getReportID());
        this.responseType.setRRTotalNonRespReportData(data);
        return this.responseType;
    }

    public void setcensusRrTotalNonRespRportQuery(String acensusRrTotalNonRespRportQuery) {
        this.censusRrTotalNonRespRportQuery = acensusRrTotalNonRespRportQuery;
    }
}

