/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.CensusPatientCountDataType;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientMaxNumberOfDaysDataType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalNonRespMaxReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalNonRespMaxReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.VendorPatientMaxNumberOfDaysDataType;
import gov.va.med.cds.exception.PersistenceException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusRrTotalNonRespMaxRportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String censusRrTotalNonRespMaxRportQuery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
        RRTotalNonRespMaxReportFilterType filter = aReportFilter.getRRTotalNonRespMaxReportFilter();
        XMLGregorianCalendar xmlStartDate = filter.getStartDate();
        XMLGregorianCalendar xmlEndDate = filter.getEndDate();
        Date sqlStartDate = this.formatDate(xmlStartDate);
        Date sqlEndDate = this.formatDate(xmlEndDate);
        List results = null;
        try (Session aSession = this.sessionFactory.getCurrentSession();){
            Query query = aSession.getNamedQuery(this.censusRrTotalNonRespMaxRportQuery);
            String location = filter.getGeographicalArea().getLocation();
            String vendor = filter.getVendor();
            query.setDate("startDate", (java.util.Date)sqlStartDate);
            query.setDate("endDate", (java.util.Date)sqlEndDate);
            query.setString("geographicalArea", location);
            query.setString("vendor", vendor);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("========== Calling CensusRRTotalNonRespMaxRportQuery query procedure: " + this.censusRrTotalNonRespMaxRportQuery + " ======"));
                LOGGER.debug((Object)(" CensusRRTotalNonRespMaxRport   startDate: '" + sqlStartDate + "'"));
                LOGGER.debug((Object)(" CensusRRTotalNonRespMaxRport   endDate: '" + sqlEndDate + "'"));
                LOGGER.debug((Object)(" CensusRRTotalNonRespMaxRport   geographicalArea location: '" + location + "'"));
                LOGGER.debug((Object)(" CensusRRTotalNonRespMaxRport   vendor: '" + vendor + "'"));
            }
            results = this.queryForReportData(query);
        }
        List<GeographicalAreaVendorPatientMaxNumberOfDaysDataType> listData = null;
        listData = CensusRrTotalNonRespMaxRportPersistenceManager.transformDataProcess(results);
        RRTotalNonRespMaxReportDataType data = new RRTotalNonRespMaxReportDataType();
        data.getGeographicalAreaData().addAll(listData);
        data.setReportID(filter.getReportID());
        this.responseType.setRRTotalNonRespMaxReportData(data);
        return this.responseType;
    }

    public void setcensusRrTotalNonRespMaxRportQuery(String acensusRrTotalNonRespMaxRportQuery) {
        this.censusRrTotalNonRespMaxRportQuery = acensusRrTotalNonRespMaxRportQuery;
    }

    private static List<GeographicalAreaVendorPatientMaxNumberOfDaysDataType> transformDataProcess(List<CensusPatientCountDataType> dbResults) {
        ArrayList<GeographicalAreaVendorPatientMaxNumberOfDaysDataType> transformData = new ArrayList<GeographicalAreaVendorPatientMaxNumberOfDaysDataType>();
        TreeMap<String, GeographicalAreaVendorPatientMaxNumberOfDaysDataType.Vendors> treeMap = new TreeMap<String, GeographicalAreaVendorPatientMaxNumberOfDaysDataType.Vendors>();
        GeographicalAreaVendorPatientMaxNumberOfDaysDataType.Vendors vendors = null;
        VendorPatientMaxNumberOfDaysDataType vendorPatientMaxNumberOfDaysCount = null;
        for (CensusPatientCountDataType dbResult : dbResults) {
            String location = dbResult.location;
            String number = dbResult.number;
            String name = dbResult.name;
            int count = dbResult.count;
            if (!treeMap.containsKey(location)) {
                vendors = new GeographicalAreaVendorPatientMaxNumberOfDaysDataType.Vendors();
                treeMap.put(location, vendors);
            } else {
                vendors = (GeographicalAreaVendorPatientMaxNumberOfDaysDataType.Vendors)treeMap.get(location);
            }
            vendorPatientMaxNumberOfDaysCount = new VendorPatientMaxNumberOfDaysDataType();
            vendorPatientMaxNumberOfDaysCount.setMaxNumberOfDays(count);
            vendorPatientMaxNumberOfDaysCount.setName(name);
            vendorPatientMaxNumberOfDaysCount.setNumber(number);
            vendors.getVendor().add(vendorPatientMaxNumberOfDaysCount);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            String key = (String)entry.getKey();
            vendors = (GeographicalAreaVendorPatientMaxNumberOfDaysDataType.Vendors)entry.getValue();
            GeographicalAreaVendorPatientMaxNumberOfDaysDataType geoType = new GeographicalAreaVendorPatientMaxNumberOfDaysDataType();
            geoType.setLocation(key);
            geoType.setVendors(vendors);
            transformData.add(geoType);
        }
        return transformData;
    }
}

