/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.CensusHighlyRuralVISNADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusHighlyRuralVISNADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusHighlyRuralVISNADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusHighlyRuralVISNADCReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String hthHighlyRuralVISNADCDataQuery = "SurveyReports.HighlyruralvisnAdcReport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        CensusHighlyRuralVISNADCReportFilterType filter = aReportFilter.getCensusHighlyRuralVISNADCReportFilter();
        CensusHighlyRuralVISNADCReportDataType data = new CensusHighlyRuralVISNADCReportDataType();
        List<CensusHighlyRuralVISNADCLocationReportDataType> results = null;
        try (Session session = this.sessionFactory.getCurrentSession();){
            results = this.getHighlyRuralVISNADCData(session, filter);
            data.getReportData().addAll(results);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setCensusHighlyRuralVISNADCReportData(data);
        return this.responseType;
    }

    private List<CensusHighlyRuralVISNADCLocationReportDataType> getHighlyRuralVISNADCData(Session aSession, CensusHighlyRuralVISNADCReportFilterType censusReportFilter) throws PersistenceException {
        String location = censusReportFilter.getGeographicalArea().getLocation();
        java.sql.Date startDate = this.formatDate(censusReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(censusReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.hthHighlyRuralVISNADCDataQuery);
        query.setString("location", location);
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling stored proc: *****(  " + this.hthHighlyRuralVISNADCDataQuery + "  )*****"));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = null;
        try {
            results = this.queryForReportData(query);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getHighlyRuralVISNADCData " + e));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("----- Done with stored proc " + this.hthHighlyRuralVISNADCDataQuery));
        }
        return results;
    }

    public void setHthHighlyRuralVISNADCDataQuery(String hthHighlyRuralVISNADCDataQuery) {
        this.hthHighlyRuralVISNADCDataQuery = hthHighlyRuralVISNADCDataQuery;
    }
}

