/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.CensusTransformData;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.COCTotalPtL2ReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.COCTotalPtL2ReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusCoCTotalPtL2ReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String censusCoCTotalPtL2ReportQuery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
        COCTotalPtL2ReportFilterType filter = aReportFilter.getCoCTotalPtL2ReportFilter();
        XMLGregorianCalendar xmlStartDate = filter.getStartDate();
        XMLGregorianCalendar xmlEndDate = filter.getEndDate();
        java.sql.Date sqlStartDate = this.formatDate(xmlStartDate);
        java.sql.Date sqlEndDate = this.formatDate(xmlEndDate);
        List results = null;
        try (Session aSession = this.sessionFactory.getCurrentSession();){
            Query query = aSession.getNamedQuery(this.censusCoCTotalPtL2ReportQuery);
            String location = filter.getGeographicalArea().getLocation();
            String vendor = filter.getVendor();
            query.setDate("startDate", (Date)sqlStartDate);
            query.setDate("endDate", (Date)sqlEndDate);
            query.setString("geographicalArea", location);
            query.setString("vendor", vendor);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("========== Calling CensusCoCTotalPtL2Report query procedure: " + this.censusCoCTotalPtL2ReportQuery + " ======"));
                LOGGER.debug((Object)(" CensusCoCTotalPtL2Report   startDate: '" + sqlStartDate + "'"));
                LOGGER.debug((Object)(" CensusCoCTotalPtL2Report   endDate: '" + sqlEndDate + "'"));
                LOGGER.debug((Object)(" CensusCoCTotalPtL2Report   geographicalArea location: '" + location + "'"));
                LOGGER.debug((Object)(" CensusCoCTotalPtL2Report   vendor: '" + vendor + "'"));
            }
            results = this.queryForReportData(query);
        }
        List<GeographicalAreaVendorPatientCountDataType> listData = null;
        listData = CensusTransformData.transformDataProcess(results);
        COCTotalPtL2ReportDataType data = new COCTotalPtL2ReportDataType();
        data.getGeographicalAreaData().addAll(listData);
        data.setReportID(filter.getReportID());
        this.responseType.setCoCTotalPtL2ReportData(data);
        return this.responseType;
    }

    public void setcensusCoCTotalPtL2ReportQuery(String acensusCoCTotalPtL2ReportQuery) {
        this.censusCoCTotalPtL2ReportQuery = acensusCoCTotalPtL2ReportQuery;
    }
}

