/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.CensusCellCountReportPersistenceManagerInterface;
import gov.va.med.cds.ars.persistence.CensusTransformData;
import gov.va.med.cds.ars.requestresponse.generated.CensusCellPatientCountReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusCellPatientCountReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusCellCountReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements CensusCellCountReportPersistenceManagerInterface {
    protected String censusCellCountReportQuery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
        CensusCellPatientCountReportFilterType filter = aReportFilter.getCensusCellPatientCountReportFilter();
        XMLGregorianCalendar xmlStartDate = filter.getStartDate();
        XMLGregorianCalendar xmlEndDate = filter.getEndDate();
        java.sql.Date sqlStartDate = this.formatDate(xmlStartDate);
        java.sql.Date sqlEndDate = this.formatDate(xmlEndDate);
        List results = null;
        try (Session aSession = this.sessionFactory.getCurrentSession();){
            Query query = aSession.getNamedQuery(this.censusCellCountReportQuery);
            String location = filter.getGeographicalArea().getLocation();
            String vendor = filter.getVendor();
            query.setDate("startDate", (Date)sqlStartDate);
            query.setDate("endDate", (Date)sqlEndDate);
            query.setString("geographicalArea", location);
            query.setString("vendor", vendor);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("========== Calling CensusPatientCountReport query procedure: " + this.censusCellCountReportQuery + " ======"));
                LOGGER.debug((Object)(" CensusPatientCountReport  startDate: '" + sqlStartDate + "'"));
                LOGGER.debug((Object)(" CensusPatientCountReport  endDate: '" + sqlEndDate + "'"));
                LOGGER.debug((Object)(" CensusPatientCountReport  geographicalArea location: '" + location + "'"));
                LOGGER.debug((Object)(" CensusPatientCountReport  vendor: '" + vendor + "'"));
            }
            results = this.queryForReportData(query);
        }
        List<GeographicalAreaVendorPatientCountDataType> listData = null;
        listData = CensusTransformData.transformDataProcess(results);
        CensusCellPatientCountReportDataType data = new CensusCellPatientCountReportDataType();
        data.getGeographicalAreaData().addAll(listData);
        data.setReportID(filter.getReportID());
        this.responseType.setCensusCellPatientCountReportData(data);
        return this.responseType;
    }

    public void setCensusCellCountReportQuery(String aCensusCellCountReportQuery) {
        this.censusCellCountReportQuery = aCensusCellCountReportQuery;
    }
}

