/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.exceptionframework;

import gov.va.med.cds.ars.exception.InitializationException;
import gov.va.med.cds.ars.exceptionframework.ExceptionHandlerInterface;
import gov.va.med.cds.exception.AbstractCdsBaseException;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exceptionframework.ExceptionInfo;
import gov.va.med.cds.exceptionframework.ExceptionLoggerInterface;
import gov.va.med.cds.exceptionframework.ExceptionUtil;
import gov.va.med.cds.exceptionframework.LoggingSeverity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseExceptionHandler
implements ExceptionHandlerInterface {
    private ExceptionLoggerInterface guaranteedLogger = null;
    private Map<String, List<ExceptionInfo>> exceptionInfoListMap = new HashMap<String, List<ExceptionInfo>>();

    private void handleArsException(AbstractCdsBaseException businessException, String entryPoint, String requestId, String uniqueIdentifier, String applicationName) {
        ErrorCodeEnum errorCodeEnum = businessException.getErrorCode();
        String clientMessage = null;
        if (errorCodeEnum != null) {
            clientMessage = ExceptionUtil.formatMessage((String)errorCodeEnum.getClientMessage(), (String[])businessException.getCustomMsgValues());
            this.populateExceptionInfo(uniqueIdentifier, (Throwable)businessException, clientMessage, errorCodeEnum, errorCodeEnum.getLoggingSeverity());
            for (ExceptionLoggerInterface logger : errorCodeEnum.getLoggers()) {
                try {
                    logger.log(this.getExceptionInfoList(uniqueIdentifier), errorCodeEnum.getLoggingSeverity(), entryPoint, requestId, applicationName);
                }
                catch (RuntimeException e) {
                    this.getGuaranteedLogger().log(this.populateExceptionInfo(uniqueIdentifier, (RuntimeException)businessException, "RuntimeException"), "logger " + logger + "not configured.", entryPoint, requestId, applicationName);
                }
            }
            this.getGuaranteedLogger().log(this.getExceptionInfoList(uniqueIdentifier), errorCodeEnum.getLoggingSeverity(), entryPoint, requestId, applicationName);
            if (errorCodeEnum.getLoggingSeverity() == LoggingSeverity.FATAL) {
                throw businessException;
            }
        } else {
            String msg = "Exception not mapped: ";
            clientMessage = msg + businessException.getClass().getName();
            this.getGuaranteedLogger().log(this.populateExceptionInfo(uniqueIdentifier, (RuntimeException)businessException, clientMessage), clientMessage, entryPoint, requestId, applicationName);
            throw businessException;
        }
    }

    private ExceptionInfo populateExceptionInfo(String uniqueIdentifier, Throwable businessException, String clientMessage, ErrorCodeEnum errorCode, LoggingSeverity loggingSeverity) {
        ExceptionInfo exceptionInfo = new ExceptionInfo();
        exceptionInfo.setClientMessage(clientMessage);
        exceptionInfo.setErrorCode(errorCode);
        exceptionInfo.setException(businessException);
        exceptionInfo.setExceptionMessage(businessException.getMessage());
        exceptionInfo.setLoggingSeverity(loggingSeverity);
        this.getExceptionInfoList(uniqueIdentifier).add(exceptionInfo);
        return exceptionInfo;
    }

    private ExceptionInfo populateExceptionInfo(String uniqueIdentifier, RuntimeException runtimeException, String clientMessage) {
        ExceptionInfo exceptionInfo = new ExceptionInfo();
        exceptionInfo.setClientMessage(clientMessage);
        exceptionInfo.setRuntimeException(runtimeException);
        this.getExceptionInfoList(uniqueIdentifier).add(exceptionInfo);
        return exceptionInfo;
    }

    @Override
    public void handleException(RuntimeException exception, String entryPoint, String requestId, String uniqueIdentifier, String applicationName) {
        if (this.getGuaranteedLogger() == null) {
            throw new InitializationException(ErrorCodeEnum.GUARANTEED_LOGGER_NOT_CONFIGURED_AND_NULL);
        }
        if (!(exception instanceof AbstractCdsBaseException)) {
            String clientMessage = "Runtime exception occured: " + exception.getClass().getName();
            ExceptionInfo exp = this.populateExceptionInfo(uniqueIdentifier, exception, clientMessage, ErrorCodeEnum.ROOT_CAUSE_MSG, LoggingSeverity.ERROR);
            this.getGuaranteedLogger().log(exp, clientMessage, entryPoint, requestId, applicationName);
            throw exception;
        }
        this.handleArsException((AbstractCdsBaseException)exception, entryPoint, requestId, uniqueIdentifier, applicationName);
    }

    @Override
    public synchronized void clear(String uniqueIdentifier) {
        if (this.exceptionInfoListMap.containsKey(uniqueIdentifier)) {
            this.exceptionInfoListMap.remove(uniqueIdentifier);
        }
    }

    public ExceptionLoggerInterface getGuaranteedLogger() {
        return this.guaranteedLogger;
    }

    public void setGuaranteedLogger(ExceptionLoggerInterface guaranteedLogger) {
        this.guaranteedLogger = guaranteedLogger;
    }

    @Override
    public synchronized List<ExceptionInfo> getExceptionInfoList(String uniqueIdentifier) {
        if (!this.exceptionInfoListMap.containsKey(uniqueIdentifier)) {
            this.exceptionInfoListMap.put(uniqueIdentifier, new ArrayList());
        }
        return this.exceptionInfoListMap.get(uniqueIdentifier);
    }

    @Override
    public boolean hasErrors(String uniqueIdentifier) {
        return this.getExceptionInfoList(uniqueIdentifier).size() > 0;
    }
}

