/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars;

import gov.va.med.cds.ars.AggregateReportingServiceInterface;
import gov.va.med.cds.ars.audit.ReadAuditLogger;
import gov.va.med.cds.ars.request.RequestProcessorInterface;
import java.util.Date;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.ws.BindingType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

@Stateless(mappedName="ARService")
@WebService(portName="AggregateReportingServicePort", serviceName="ARService", targetNamespace="http://cds.med.DNS   /", wsdlLocation="wsdls/ARService.wsdl", endpointInterface="gov.va.med.cds.ars.AggregateReportingServiceInterface")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
@HandlerChain(file="handlers.xml")
@Interceptors(value={SpringBeanAutowiringInterceptor.class})
public class AggregateReportingService
implements AggregateReportingServiceInterface {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    private ReadAuditLogger auditLogger;
    @Autowired
    @Qualifier(value="requestProcessor")
    private RequestProcessorInterface reportProcessor = null;

    public void init() {
        this.logger.debug((Object)"initializing the Patient Messaging Service.");
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    @Override
    @WebMethod
    public String readAggregateData(String reportRequest, String reportId, String clientId, String requestId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("++++++++++ Entered readAggregateData with reportRequest " + reportRequest));
            this.logger.debug((Object)("++++++++++ Entered readAggregateData with reportRequest: " + reportRequest));
            this.logger.debug((Object)("++++++++++ Entered readAggregateData with reportId: " + reportId));
            this.logger.debug((Object)("++++++++++ Entered readAggregateData with clientId: " + clientId));
            this.logger.debug((Object)("++++++++++ Entered readAggregateData with requestId: " + requestId));
        }
        Long startTime = new Date().getTime();
        String readResult = this.reportProcessor.readAggregateData(reportRequest, reportId, clientId, requestId);
        this.auditLogger.recordAuditLog(startTime, readResult, reportRequest, reportId, clientId, requestId);
        return readResult;
    }
}

