/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.xml.transform;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.xml.transform.TransformerInterface;
import gov.va.med.cds.xml.transform.XsltTransformationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.DocumentResult;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.xml.sax.InputSource;

public final class XsltHelper
implements TransformerInterface {
    private static Log logger = LogFactory.getLog(XsltHelper.class);
    private Map<String, Templates> xsltTemplate = new HashMap<String, Templates>();

    public XsltHelper() {
    }

    public XsltHelper(List<String> xsltLocations, List<ExtensionFunctionDefinition> extFunctions) throws TransformerConfigurationException, IOException {
        this.loadXsltTransformsIntoMemory(xsltLocations, extFunctions);
    }

    private void loadXsltTransformsIntoMemory(List<String> xsltLocations) throws IOException, TransformerConfigurationException {
        this.loadXsltTransformsIntoMemory(xsltLocations, new ArrayList<ExtensionFunctionDefinition>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadXsltTransformsIntoMemory(List<String> xsltLocations, List<ExtensionFunctionDefinition> extFunctions) throws IOException, TransformerConfigurationException {
        StreamSource templateStreamSource = null;
        InputStream is = null;
        TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
        Configuration saxonConfig = transformerFactory.getConfiguration();
        this.registerSaxonExtensionFunctions(saxonConfig, extFunctions);
        Resource[] resources = null;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (String xsltPath : xsltLocations) {
            for (Resource resource : resources = resolver.getResources(xsltPath.trim())) {
                try {
                    logger.debug((Object)("XSLT resource: " + resource.getFilename() + " is being loaded."));
                    is = resource.getInputStream();
                    templateStreamSource = new StreamSource(is);
                    this.xsltTemplate.put(resource.getFilename(), transformerFactory.newTemplates(templateStreamSource));
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }
    }

    private void registerSaxonExtensionFunctions(Configuration saxonConfig, List<ExtensionFunctionDefinition> extFunctions) {
        for (ExtensionFunctionDefinition extFunction : extFunctions) {
            saxonConfig.registerExtensionFunction(extFunction);
        }
    }

    @Override
    public String transformMessageAsString(String source, String xsltKey) {
        return this.transformMessageAsString(source, xsltKey, null);
    }

    @Override
    public String transformMessageAsString(String source, String xsltKey, Map<String, Object> parameters) {
        try {
            Document result = this.transformMessage(source, xsltKey, parameters);
            String tempStr = result.asXML();
            return tempStr;
        }
        catch (Exception e) {
            throw new XsltTransformationException(ErrorCodeEnum.XSLT_HELPER_TRANSLATION_EXCEPTION, (Throwable)e, xsltKey);
        }
    }

    @Override
    public String transformMessageAsPlainText(String source, String xsltKey) {
        return this.transformMessageAsPlainText(source, xsltKey, null);
    }

    @Override
    public String transformMessageAsPlainText(String source, String xsltKey, Map<String, Object> parameters) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bos);
            Transformer transformer = this.getXsltTransformer(xsltKey);
            this.setTransformerParameters(transformer, parameters);
            transformer.transform(new SAXSource(new InputSource(new StringReader(source))), result);
            String tempStr = bos.toString();
            bos.flush();
            bos.close();
            return tempStr;
        }
        catch (Exception e) {
            throw new XsltTransformationException(ErrorCodeEnum.XSLT_HELPER_TRANSLATION_EXCEPTION, (Throwable)e, xsltKey);
        }
    }

    @Override
    public Document transformMessage(String source, String xsltKey) {
        return this.transformMessage(source, xsltKey, null);
    }

    @Override
    public Document transformMessage(String source, String xsltKey, Map<String, Object> parameters) {
        try {
            Transformer transformer = this.getXsltTransformer(xsltKey);
            this.setTransformerParameters(transformer, parameters);
            DocumentResult result = new DocumentResult();
            transformer.transform(new SAXSource(new InputSource(new StringReader(source))), (Result)result);
            return result.getDocument();
        }
        catch (Exception e) {
            throw new XsltTransformationException(ErrorCodeEnum.XSLT_HELPER_TRANSLATION_EXCEPTION, (Throwable)e, xsltKey);
        }
    }

    private void setTransformerParameters(Transformer transformer, Map<String, Object> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    public Transformer getXsltTransformer(String xsltTransformerName) throws TransformerConfigurationException {
        return this.xsltTemplate.get(xsltTransformerName).newTransformer();
    }

    public void setXsltLocations(List<String> xsltLocations) throws Exception {
        this.loadXsltTransformsIntoMemory(xsltLocations);
    }
}

