/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.audit;

import gov.va.med.cds.audit.ClientMapping;
import gov.va.med.cds.audit.FilterIdWrapper;
import gov.va.med.cds.audit.TemplateIdWrapper;
import gov.va.med.cds.util.DateTimeUtil;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;

public abstract class AbstractAuditLog
implements Serializable {
    private static final Log logger = LogFactory.getLog(AbstractAuditLog.class);
    private static final long serialVersionUID = 1L;
    protected static final String ADD_NEW_LINE = "\n";
    protected static final String ADD_TAB = "\t";
    protected static final String ADD_DOUBLE_TAB = "\t\t";
    private static final String DOMAIN_NAME = "CDS v3.x";
    private Long auditLogId;
    private Date localTime;
    protected String isoLocalTime = DateTimeUtil.getISOTime(new Date().getTime(), null);
    private ClientMapping clientMapping;
    private String clientId;
    private String clientRequestInitiationTime;
    private TemplateIdWrapper templateId = new TemplateIdWrapper();
    protected String filterRequest;
    private FilterIdWrapper filterId = new FilterIdWrapper();
    private String facility;
    private String response;
    protected long startTime;
    protected long endTime;
    private long milliseconds;
    protected String requestId;
    protected String sendingApplication;
    protected String debugInfo;
    private int responseSize = -1;
    private int responseLength = -1;
    private String machine;
    private String appName;

    public int getResponseSize() {
        if (this.responseSize < 0) {
            this.responseSize = this.response != null ? this.response.getBytes().length : 0;
        }
        return this.responseSize;
    }

    public void setResponseSize(int responseSize) {
        this.responseSize = responseSize;
    }

    public int getResponseLength() {
        if (this.responseLength < 0) {
            this.responseLength = this.getResponseLength(this.response);
        }
        return this.responseLength;
    }

    public void setResponseLength(int responseLength) {
        this.responseLength = responseLength;
    }

    public String getMachine() {
        if (this.machine == null) {
            try {
                this.machine = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.machine;
    }

    public void setMachine(String machine) {
        this.machine = machine;
    }

    public Long getAuditLogId() {
        return this.auditLogId;
    }

    private void setAuditLogId(Long auditLogId) {
        this.auditLogId = auditLogId;
    }

    public String getDebugInfo() {
        StringBuilder auditInfo = new StringBuilder();
        auditInfo.append("Server CDS v3.x ==> Audit detail: ");
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_TAB);
        auditInfo.append("domain => ");
        auditInfo.append(DOMAIN_NAME);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_TAB);
        auditInfo.append("start_milliseconds => ");
        auditInfo.append(this.startTime);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_TAB);
        auditInfo.append("milliseconds => ");
        auditInfo.append(this.getMilliseconds());
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_TAB);
        auditInfo.append("ISO_localtime => ");
        auditInfo.append(this.isoLocalTime);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_TAB);
        auditInfo.append("log_information => ");
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_DOUBLE_TAB);
        auditInfo.append("startTime -> ");
        auditInfo.append(this.startTime);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_DOUBLE_TAB);
        auditInfo.append("sendingApplication -> ");
        auditInfo.append(this.sendingApplication);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_DOUBLE_TAB);
        auditInfo.append("originalMessageControlId -> ");
        auditInfo.append(this.requestId);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_DOUBLE_TAB);
        auditInfo.append("requesterString -> ");
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_DOUBLE_TAB);
        auditInfo.append("requestMsg -> ");
        auditInfo.append(this.filterRequest);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_DOUBLE_TAB);
        auditInfo.append("receivingApplication -> ");
        auditInfo.append(DOMAIN_NAME);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_DOUBLE_TAB);
        auditInfo.append("completionTime -> ");
        auditInfo.append(Long.toString(this.endTime));
        this.debugInfo = auditInfo.toString();
        return this.debugInfo;
    }

    public void setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
        Map<String, String> debugInfoMap = this.parseDebugInfo(debugInfo);
        this.setStartTime(Long.parseLong(debugInfoMap.get("start_milliseconds")));
        this.setMilliseconds(Long.parseLong(debugInfoMap.get("milliseconds")));
        this.setIsoLocalTime(debugInfoMap.get("ISO_localtime"));
        this.setSendingApplication(debugInfoMap.get("sendingApplication"));
        this.setRequestId(debugInfoMap.get("originalMessageControlId"));
        this.setFilterRequest(debugInfoMap.get("requestMsg"));
        this.setEndTime(Long.parseLong(debugInfoMap.get("completionTime")));
    }

    public String getDomainName() {
        return DOMAIN_NAME;
    }

    public ClientMapping getClientMapping() {
        return this.clientMapping;
    }

    public void setClientMapping(ClientMapping aClientMapping) {
        this.clientMapping = aClientMapping;
    }

    public String getFilterId() {
        return this.filterId.getFilterId();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public FilterIdWrapper getFilterIdWrapper() {
        return this.filterId;
    }

    public String getTemplateId() {
        return this.templateId.getTemplateId();
    }

    public TemplateIdWrapper getTemplateIdWrapper() {
        return this.templateId;
    }

    public void setFilterIdWrapper(FilterIdWrapper aFilterIdWrapper) {
        this.filterId = aFilterIdWrapper;
    }

    public void setTemplateIdWrapper(TemplateIdWrapper aTemplateIdWrapper) {
        this.templateId = aTemplateIdWrapper;
    }

    public void setTemplateId(String aTemplateId) {
        this.templateId.setTemplateId(aTemplateId);
        if (this.clientMapping == null) {
            this.clientMapping = new ClientMapping(null, aTemplateId);
        } else {
            this.clientMapping.setTemplateId(aTemplateId);
        }
    }

    public String getFilterRequest() {
        return this.filterRequest;
    }

    public void setFilterRequest(String filterRequest) {
        this.filterRequest = filterRequest;
        try {
            Document filterDocument = DocumentHelper.parseText((String)filterRequest);
            this.setClientId(filterDocument.getRootElement().elementTextTrim("clientName"));
            this.setClientRequestInitiationTime(filterDocument.getRootElement().elementTextTrim("clientRequestInitiationTime"));
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("Filter request document is not valid XML.", e);
        }
    }

    public void setFilterId(String aFilterId) {
        this.filterId.setFilterId(aFilterId);
        if (this.clientMapping == null) {
            this.clientMapping = new ClientMapping(aFilterId, null);
        } else {
            this.clientMapping.setFilterId(aFilterId);
        }
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public String getIsoLocalTime() {
        return this.isoLocalTime;
    }

    public void setIsoLocalTime(String isoLocalTime) {
        this.isoLocalTime = isoLocalTime;
    }

    public Date getLocalTime() {
        return this.localTime;
    }

    public void setLocalTime(Date localTime) {
        this.localTime = localTime;
    }

    public long getMilliseconds() {
        this.milliseconds = this.endTime - this.startTime;
        return this.milliseconds;
    }

    public void setMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public String getSendingApplication() {
        return this.sendingApplication;
    }

    public void setSendingApplication(String sendingApplication) {
        this.sendingApplication = sendingApplication;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    protected Map<String, String> parseDebugInfo(String debugInfo) {
        String[] infos;
        Hashtable<String, String> data = new Hashtable<String, String>();
        String delim = "=>";
        debugInfo = debugInfo.substring(debugInfo.indexOf("Audit detail: ") + "Audit detail: ".length());
        for (String info : infos = debugInfo.split(ADD_NEW_LINE)) {
            if ((info = info.trim()).startsWith("Server")) continue;
            if (info.startsWith("log_information")) {
                delim = "->";
                continue;
            }
            String[] arr = info.split(delim);
            data.put(arr[0].trim(), arr.length == 2 ? arr[1].trim() : "");
        }
        return data;
    }

    protected abstract int getResponseLength(String var1);

    public String getAppName() {
        return this.appName;
    }

    public String getClientRequestInitiationTime() {
        return this.clientRequestInitiationTime;
    }

    public void setClientRequestInitiationTime(String clientRequestInitiationTime) {
        this.clientRequestInitiationTime = clientRequestInitiationTime;
    }
}

