/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ejb;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.RuntimeMDBOnMessageException;
import gov.va.med.cds.response.util.ResponseErrorSectionExtractor;
import gov.va.med.cds.util.MllpUtil;
import gov.va.med.mediator.client.messagemediator.MessageMediatorInterface;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.interceptor.Interceptors;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;
import org.springframework.jndi.JndiTemplate;

@Interceptors(value={SpringBeanAutowiringInterceptor.class})
public class CDSClinicalMdb
implements MessageListener {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    private MessageMediatorInterface messageMediator;
    @Autowired
    private ResponseErrorSectionExtractor responseErrorSectionExtractor;
    private Boolean defaultPersistOriginalMessage;

    public void ejbCreate() {
        try {
            this.defaultPersistOriginalMessage = (Boolean)new JndiTemplate().lookup("java:comp/env/ejb/mediator/defaultPersistOriginalMessage", Boolean.class);
        }
        catch (Exception e) {
            this.logger.warn((Object)String.format("Error creating Clinical Message Driven Bean. Could not identify processor. Error Reason: %s", e.getMessage()), (Throwable)e);
        }
    }

    public void onMessage(Message message) {
        try {
            byte[] messageBytes = null;
            Boolean persistOriginal = message.propertyExists("persistOriginalMessage") ? message.getBooleanProperty("persistOriginalMessage") : this.defaultPersistOriginalMessage.booleanValue();
            if (message instanceof BytesMessage) {
                BytesMessage bytesMsg = (BytesMessage)message;
                int msgLength = (int)bytesMsg.getBodyLength();
                messageBytes = new byte[msgLength];
                bytesMsg.readBytes(messageBytes);
            } else if (message instanceof TextMessage) {
                TextMessage textMsg = (TextMessage)message;
                messageBytes = textMsg.getText().getBytes();
            }
            ByteBuffer messageBuffer = ByteBuffer.wrap(messageBytes);
            messageBuffer = MllpUtil.decode((ByteBuffer[])new ByteBuffer[]{messageBuffer}, (boolean)true, (Charset)Charset.forName("ISO-8859-1"), (Charset)Charset.defaultCharset());
            String response = this.messageMediator.processMessage(new String(messageBuffer.array()), persistOriginal);
            this.responseErrorSectionExtractor.checkForErrorsInResponse(response);
        }
        catch (JMSException jmsE) {
            String msg = jmsE.getMessage();
            this.logger.error((Object)msg, (Throwable)jmsE);
            throw new RuntimeMDBOnMessageException(ErrorCodeEnum.MDB_ON_MESSAGE_JMS_EXCEPTION, (Throwable)jmsE, new String[]{msg});
        }
    }

    public void setMessageMediator(MessageMediatorInterface messageMediator) {
        this.messageMediator = messageMediator;
    }

    public void setResponseErrorSectionExtractor(ResponseErrorSectionExtractor responseErrorSectionExtractor) {
        this.responseErrorSectionExtractor = responseErrorSectionExtractor;
    }
}

