/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.MllpIllegalEncodingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class MllpUtil {
    public static final byte SOB = 11;
    public static final byte EOB = 28;
    public static final byte LF = 10;
    public static final byte CR = 13;

    public static ByteBuffer decode(ByteBuffer[] buffers, Charset inCharset, Charset outCharset) {
        return MllpUtil.decode(buffers, false, inCharset, outCharset);
    }

    public static ByteBuffer decode(ByteBuffer[] buffers, boolean ignoreEob, Charset inCharset, Charset outCharset) {
        boolean eobFound = false;
        StringBuffer buffer = new StringBuffer();
        for (ByteBuffer byteBuffer : buffers) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(byteBuffer.array(), 0, byteBuffer.limit()), inCharset);
                int i = -1;
                while ((i = reader.read()) != -1) {
                    char c = (char)i;
                    if (eobFound) {
                        if (i != 0 && i == 13) continue;
                        throw new MllpIllegalEncodingException(ErrorCodeEnum.MLLP_ILLEGAL_ENCODING_EXCEPTION);
                    }
                    if (c == '\u000b') continue;
                    if (c == '\u001c') {
                        eobFound = true;
                        continue;
                    }
                    buffer.append(c);
                }
            }
            catch (IOException e) {
                throw new MllpIllegalEncodingException(ErrorCodeEnum.MLLP_ILLEGAL_ENCODING_EXCEPTION, (Throwable)e);
            }
        }
        return eobFound || ignoreEob ? MllpUtil.doCharacterEncoding(buffer.toString(), outCharset) : null;
    }

    public static ByteBuffer encode(ByteBuffer byteBuffer, Charset inCharset, Charset outCharset) {
        StringBuffer buffer = new StringBuffer();
        byteBuffer = MllpUtil.decode(new ByteBuffer[]{byteBuffer}, true, inCharset, inCharset);
        InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(byteBuffer.array(), 0, byteBuffer.limit()), inCharset);
        buffer.append('\u000b');
        int i = -1;
        int last = 0;
        try {
            while ((i = reader.read()) != -1) {
                char c = (char)i;
                if (i == 10) {
                    if (last != 13 && last != 10) {
                        buffer.append('\r');
                    }
                    last = i;
                    continue;
                }
                buffer.append(c);
                last = i;
            }
        }
        catch (IOException e) {
            throw new MllpIllegalEncodingException(ErrorCodeEnum.MLLP_ILLEGAL_ENCODING_EXCEPTION, (Throwable)e);
        }
        buffer.append('\r').append('\u001c').append('\r');
        buffer.trimToSize();
        return MllpUtil.doCharacterEncoding(buffer.toString(), outCharset);
    }

    private static ByteBuffer doCharacterEncoding(String str, Charset encodingCharset) {
        byte[] buff = encodingCharset.encode(str).array();
        return ByteBuffer.wrap(Arrays.copyOf(buff, buff.length - MllpUtil.countTrailingNullBytes(buff)));
    }

    private static int countTrailingNullBytes(byte[] buff) {
        int countNulls = 0;
        for (int i = buff.length - 1; i != 0 && buff[i] == 0; --i) {
            ++countNulls;
        }
        return countNulls;
    }
}

