/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.response.util;

import gov.va.med.cds.exception.ResponseException;
import gov.va.med.cds.util.LogMessageUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public class ResponseErrorSectionExtractor {
    private static Log logger = LogFactory.getLog(ResponseErrorSectionExtractor.class);
    private Document documentObj;
    private List<Node> nodeList;
    private List<Node> childNodeList;
    private List<String> severityList;

    public Document getDocument(String response) {
        Document docObj;
        block2: {
            docObj = null;
            try {
                docObj = DocumentHelper.parseText((String)response);
            }
            catch (DocumentException e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error((Object)LogMessageUtil.buildMessage(null, null, "CDS", String.format("CDS response document could not be parsed: %s ", e.getMessage())), (Throwable)e);
            }
        }
        return docObj;
    }

    public String getErrorSection(String response) {
        this.documentObj = this.getDocument(response);
        this.nodeList = new ArrayList<Node>(this.documentObj.selectNodes("//ClinicalData/errorSection/*"));
        StringBuilder errorMessage = new StringBuilder();
        if (this.nodeList.size() > 0) {
            errorMessage = new StringBuilder("Unable to process message.  Following is a list of one or more exceptions encountered: ");
            int nodeQuantifier = 0;
            for (String severity : this.severityList) {
                for (Node node : this.nodeList) {
                    if (!severity.equalsIgnoreCase(node.getName())) continue;
                    errorMessage.append(String.format("ErrorSevirity : %s\t", node.getName()));
                    this.childNodeList = new ArrayList<Node>(node.selectNodes("//ClinicalData/errorSection/" + severity + "[" + ++nodeQuantifier + "]/*"));
                    for (Node childNode : this.childNodeList) {
                        if ("errorCode".equalsIgnoreCase(childNode.getName())) {
                            errorMessage.append(String.format("ErrorCode : %s\t", childNode.getText()));
                        }
                        if (!"displayMessage".equalsIgnoreCase(childNode.getName())) continue;
                        errorMessage.append(String.format("DisplayMessage : %s\n", childNode.getText()));
                    }
                }
                nodeQuantifier = 0;
            }
        }
        return errorMessage.toString();
    }

    public void checkForErrorsInResponse(String response) throws ResponseException {
        String errorSection = this.getErrorSection(response);
        if (errorSection.length() > 0) {
            throw new ResponseException(errorSection);
        }
    }

    @Resource
    public void setSeverityList(List<String> severityList) {
        this.severityList = severityList;
    }
}

