/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.monitor.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class MBeanConnection {
    private MBeanServerConnection connection;
    private JMXConnector connector;
    private ObjectName service;

    public void initConnection(String hostname, String portString, String username, String password, String serviceName) throws IOException, MalformedURLException, MalformedObjectNameException {
        String protocol = "t3";
        Integer portInteger = Integer.valueOf(portString);
        int port = portInteger;
        String jndiroot = "/jndi/";
        String mserver = "weblogic.management.mbeanservers.runtime";
        JMXServiceURL serviceURL = new JMXServiceURL(protocol, hostname, port, jndiroot + mserver);
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("java.naming.security.principal", username);
        h.put("java.naming.security.credentials", password);
        h.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        this.connector = JMXConnectorFactory.connect(serviceURL, h);
        this.connection = this.connector.getMBeanServerConnection();
        this.service = new ObjectName(serviceName);
    }

    public void initAdminConnection(String hostname, String portString, String username, String password, String serviceName) throws IOException, MalformedURLException, MalformedObjectNameException {
        JMXServiceURL serviceUrl = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + hostname + ":" + portString + "/jmxrmi");
        HashMap<String, String> env = new HashMap<String, String>();
        String pkgs = "com.sun.enterprise.admin.jmx.remote.protocol";
        env.put("jmx.remote.protocol.provider.pkgs", pkgs);
        env.put("USER", username);
        env.put("PASSWORD", password);
        this.connector = JMXConnectorFactory.newJMXConnector(serviceUrl, env);
        this.connector.connect();
        this.connection = this.connector.getMBeanServerConnection();
        this.service = new ObjectName(serviceName);
    }

    public MBeanServerConnection getConnection() {
        return this.connection;
    }

    public ObjectName getService() {
        return this.service;
    }

    public void closeConnection() throws IOException {
        if (this.connector != null) {
            this.connector.close();
        }
    }
}

