/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.clinicaldata;

import gov.va.med.cds.clinicaldata.EntryFilter;
import gov.va.med.cds.clinicaldata.TfsFilterMetaDataInterface;
import gov.va.med.cds.clinicaldata.VhimVersionWrapper;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.FilterCacheException;
import java.io.StringReader;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class TfsFilterMetaData
implements TfsFilterMetaDataInterface {
    private String filterId;
    private Set<EntryFilter> entryFilters;
    protected Set<String> vhimVersions;
    private Schema filterSchema;
    private String filterDescription;
    private boolean containsCorrelation;
    private Date dateAdded;
    private Date dateDeprecated;
    private Date dateActivated;
    private Date dateDeactivated;
    private Date dateUpdated;
    private String status;
    private String filterSchemaXml;

    @Override
    public String getFilterId() {
        return this.filterId;
    }

    @Override
    public void setFilterId(String theFilterId) {
        this.filterId = theFilterId;
    }

    @Override
    public Set<String> getVhimVersions() {
        return this.vhimVersions;
    }

    @Override
    public void setVhimVersions(Set<String> aVhimVersions) {
        this.vhimVersions = aVhimVersions;
    }

    private Set<VhimVersionWrapper> getVhimVersionWrappers() {
        HashSet<VhimVersionWrapper> wrappers = new HashSet<VhimVersionWrapper>(this.vhimVersions.size());
        for (String vhimVersion : this.vhimVersions) {
            VhimVersionWrapper vvw = new VhimVersionWrapper();
            vvw.setVersion(vhimVersion);
            wrappers.add(vvw);
        }
        return wrappers;
    }

    private void setVhimVersionWrappers(Set<VhimVersionWrapper> aVhimVersions) {
        this.vhimVersions = new HashSet<String>(aVhimVersions.size());
        for (VhimVersionWrapper vhimVersionWrapper : aVhimVersions) {
            this.vhimVersions.add(vhimVersionWrapper.getVersion());
        }
    }

    @Override
    public Schema getFilterSchema() {
        if (this.filterSchema == null && this.filterSchemaXml != null) {
            try {
                this.setFilterSchema(this.filterSchemaXml);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.filterSchema;
    }

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public void setDateAdded(Date dateAdded) {
        this.dateAdded = dateAdded;
    }

    public Date getDateDeprecated() {
        return this.dateDeprecated;
    }

    public void setDateDeprecated(Date dateDeprecated) {
        this.dateDeprecated = dateDeprecated;
    }

    public Date getDateActivated() {
        return this.dateActivated;
    }

    public void setDateActivated(Date dateActivated) {
        this.dateActivated = dateActivated;
    }

    public Date getDateDeactivated() {
        return this.dateDeactivated;
    }

    public void setDateDeactivated(Date dateDeactivated) {
        this.dateDeactivated = dateDeactivated;
    }

    public Date getDateUpdated() {
        return this.dateUpdated;
    }

    public void setDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public void setFilterSchemaXml(String filterSchemaXml) {
        this.filterSchemaXml = filterSchemaXml;
        if (this.filterSchema == null) {
            // empty if block
        }
    }

    @Override
    public String getFilterSchemaXml() {
        return this.filterSchemaXml;
    }

    @Override
    public void setFilterSchema(String filterSchemaXml) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.filterSchema = schemaFactory.newSchema(new StreamSource(new StringReader(filterSchemaXml)));
            this.setFilterSchemaXml(filterSchemaXml);
        }
        catch (SAXException e) {
            throw new FilterCacheException(ErrorCodeEnum.ERROR_MARSHALLING_FILTER_XML, (Throwable)e, filterSchemaXml, "Provided Filter schema is invalid : " + this.filterId);
        }
    }

    @Override
    public void setFilterDescription(String filterDescription) {
        this.filterDescription = filterDescription;
    }

    @Override
    public String getFilterDescription() {
        return this.filterDescription;
    }

    public void setContainsCorrelation(boolean containsCorrelation) {
        this.containsCorrelation = containsCorrelation;
    }

    public boolean isContainsCorrelation() {
        return this.containsCorrelation;
    }

    @Override
    public void setEntryFilters(Set<EntryFilter> entryFilters) {
        this.entryFilters = entryFilters;
    }

    @Override
    public Set<EntryFilter> getEntryFilters() {
        return this.entryFilters;
    }

    public String toString() {
        return "id: " + this.getFilterId() + ", desc: " + this.getFilterDescription() + ", dateAdded: " + this.dateAdded + ", status: " + this.status + ", vhims: " + this.getVhimVersions() + ", entryFilters: " + this.getEntryFilters() + "\nXML: " + this.getFilterSchemaXml();
    }
}

