/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.audit.persistence.hibernate;

import gov.va.med.cds.audit.AbstractAuditLog;
import gov.va.med.cds.audit.ClientMappingPathways;
import gov.va.med.cds.audit.FilterIdWrapper;
import gov.va.med.cds.audit.TemplateIdWrapper;
import gov.va.med.cds.audit.VhimReadPathwaysResponseAuditLog;
import gov.va.med.cds.audit.persistence.AuditLogPersistenceManagerInterface;
import gov.va.med.cds.util.LogMessageUtil;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.hibernate4.HibernateTemplate;

public class HibernatePathwaysAuditLogPersistenceManager
implements AuditLogPersistenceManagerInterface {
    private static final Log logger = LogFactory.getLog(HibernatePathwaysAuditLogPersistenceManager.class);
    private HibernateTemplate hibernateTemplate;
    private String appName;

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Resource
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public void storeAuditLog(AbstractAuditLog auditLog) {
        VhimReadPathwaysResponseAuditLog pathwaysAuditLog = null;
        try {
            if (!(auditLog instanceof VhimReadPathwaysResponseAuditLog)) {
                throw new IllegalArgumentException(String.format("Unexpected Audit Log Type: %s.", auditLog.getClass().getName()));
            }
            pathwaysAuditLog = (VhimReadPathwaysResponseAuditLog)auditLog;
            this.persistTemplateIdWrapper(pathwaysAuditLog);
            this.persistFilterIdWrapper(pathwaysAuditLog);
            long tId = pathwaysAuditLog.getTemplateIdWrapper().getId();
            long fId = pathwaysAuditLog.getFilterIdWrapper().getId();
            String clientName = pathwaysAuditLog.getClientId();
            List hibernateResult = this.hibernateTemplate.findByNamedQueryAndNamedParam("pathways.clientmapping.filter.template", new String[]{"templateId", "filterId", "clientName"}, new Object[]{tId, fId, clientName});
            if (hibernateResult.size() == 1) {
                pathwaysAuditLog.setClientMappingPathways((ClientMappingPathways)hibernateResult.get(0));
                if (auditLog.getFacility() == null) {
                    auditLog.setFacility(pathwaysAuditLog.getClientMappingPathways().getShortName());
                }
            } else {
                pathwaysAuditLog.setClientMappingPathways(null);
            }
            this.hibernateTemplate.save((Object)pathwaysAuditLog);
            this.hibernateTemplate.flush();
        }
        catch (Exception ex) {
            logger.error((Object)LogMessageUtil.buildMessage(null, null, this.appName, "Error Auditing READ request message. "), (Throwable)ex);
        }
    }

    private void persistTemplateIdWrapper(AbstractAuditLog auditLog) {
        List hibernateTemplateIds = this.hibernateTemplate.findByNamedQueryAndNamedParam("template.name", new String[]{"templateName", "templateName"}, (Object[])new String[]{auditLog.getTemplateIdWrapper().getTemplateId(), auditLog.getTemplateIdWrapper().getTemplateId()});
        if (hibernateTemplateIds.size() < 1) {
            this.hibernateTemplate.save((Object)auditLog.getTemplateIdWrapper());
        } else {
            auditLog.setTemplateIdWrapper((TemplateIdWrapper)hibernateTemplateIds.get(0));
        }
    }

    private void persistFilterIdWrapper(VhimReadPathwaysResponseAuditLog auditLog) {
        List hibernateFilterIds = this.hibernateTemplate.findByNamedQueryAndNamedParam("filter.name", new String[]{"filterName", "filterName"}, (Object[])new String[]{auditLog.getFilterIdWrapper().getFilterId(), auditLog.getFilterIdWrapper().getFilterId()});
        if (hibernateFilterIds.size() < 1) {
            this.hibernateTemplate.save((Object)auditLog.getFilterIdWrapper());
        } else {
            auditLog.setFilterIdWrapper((FilterIdWrapper)hibernateFilterIds.get(0));
        }
    }

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }
}

