/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.audit.persistence.hibernate;

import gov.va.med.cds.audit.AbstractAuditLog;
import gov.va.med.cds.audit.ClientMapping;
import gov.va.med.cds.audit.FilterIdWrapper;
import gov.va.med.cds.audit.TemplateIdWrapper;
import gov.va.med.cds.audit.persistence.AuditLogPersistenceManagerInterface;
import gov.va.med.cds.util.LogMessageUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.orm.hibernate4.HibernateTemplate;
import org.springframework.util.StringUtils;

public class HibernateAuditLogPersistenceManager
implements AuditLogPersistenceManagerInterface {
    private static final Log logger = LogFactory.getLog(HibernateAuditLogPersistenceManager.class);
    private HibernateTemplate hibernateTemplate;
    private HibernateTemplate hibernateTemplateHa;
    private String appName;
    private List<String> haTemplateIdList;
    private Map<String, String> requestIdClientNameMap;

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Autowired
    @Qualifier(value="cdsAppName")
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public void storeAuditLog(AbstractAuditLog auditLog) {
        try {
            this.persistTemplateIdWrapper(auditLog);
            this.persistFilterIdWrapper(auditLog);
            long tId = auditLog.getTemplateIdWrapper().getId();
            long fId = auditLog.getFilterIdWrapper().getId();
            String clientName = auditLog.getClientId();
            if (!StringUtils.hasLength((String)clientName)) {
                String requestId = auditLog.getRequestId();
                for (String key : this.requestIdClientNameMap.keySet()) {
                    if (!requestId.toUpperCase().contains(key.toUpperCase())) continue;
                    clientName = this.requestIdClientNameMap.get(key);
                    break;
                }
                if (!StringUtils.hasLength((String)clientName) && auditLog.getFilterIdWrapper().getFilterId().startsWith("CHDR")) {
                    clientName = "Clinical Health Data Repository";
                }
                auditLog.setClientId(clientName);
            }
            List hibernateResult = null;
            if (StringUtils.hasLength((String)clientName)) {
                hibernateResult = this.hibernateTemplate.findByNamedQueryAndNamedParam("cds.clientmapping.filter.template.clientname", new String[]{"templateId", "filterId", "clientName"}, new Object[]{tId, fId, clientName});
                if (hibernateResult.size() == 0) {
                    hibernateResult = this.hibernateTemplate.findByNamedQueryAndNamedParam("cds.clientmapping.filter.template", new String[]{"templateId", "filterId"}, (Object[])new Long[]{tId, fId});
                }
            } else {
                hibernateResult = this.hibernateTemplate.findByNamedQueryAndNamedParam("cds.clientmapping.filter.template", new String[]{"templateId", "filterId"}, (Object[])new Long[]{tId, fId});
            }
            if (hibernateResult.size() > 0) {
                auditLog.setClientMapping((ClientMapping)hibernateResult.get(0));
                if (auditLog.getFacility() == null) {
                    auditLog.setFacility(auditLog.getClientMapping().getShortName());
                }
            } else {
                auditLog.setClientMapping(null);
            }
            if (this.haTemplateIdList.contains(auditLog.getTemplateIdWrapper().getTemplateId())) {
                this.hibernateTemplateHa.save((Object)auditLog);
                this.hibernateTemplateHa.flush();
            } else {
                this.hibernateTemplate.save((Object)auditLog);
                this.hibernateTemplate.flush();
            }
        }
        catch (RuntimeException ex) {
            logger.error((Object)LogMessageUtil.buildMessage(null, null, this.appName, "Error Auditing READ request message. "), (Throwable)ex);
        }
    }

    private void persistTemplateIdWrapper(AbstractAuditLog auditLog) {
        List hibernateTemplateIds = this.hibernateTemplate.findByNamedQueryAndNamedParam("template.name", new String[]{"templateName", "templateName"}, (Object[])new String[]{auditLog.getTemplateIdWrapper().getTemplateId(), auditLog.getTemplateIdWrapper().getTemplateId()});
        if (hibernateTemplateIds.size() < 1) {
            this.hibernateTemplate.save((Object)auditLog.getTemplateIdWrapper());
        } else {
            auditLog.setTemplateIdWrapper((TemplateIdWrapper)hibernateTemplateIds.get(0));
        }
    }

    private void persistFilterIdWrapper(AbstractAuditLog auditLog) {
        List hibernateFilterIds = this.hibernateTemplate.findByNamedQueryAndNamedParam("filter.name", new String[]{"filterName", "filterName"}, (Object[])new String[]{auditLog.getFilterIdWrapper().getFilterId(), auditLog.getFilterIdWrapper().getFilterId()});
        if (hibernateFilterIds.size() < 1) {
            this.hibernateTemplate.save((Object)auditLog.getFilterIdWrapper());
        } else {
            auditLog.setFilterIdWrapper((FilterIdWrapper)hibernateFilterIds.get(0));
        }
    }

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public void setHaTemplateIdList(List<String> haTemplateIdList) {
        this.haTemplateIdList = haTemplateIdList;
    }

    public HibernateTemplate getHibernateTemplateHa() {
        return this.hibernateTemplateHa;
    }

    public void setHibernateTemplateHa(HibernateTemplate hibernateTemplateHa) {
        this.hibernateTemplateHa = hibernateTemplateHa;
    }

    public void setRequestIdClientNameMap(Map<String, String> requestIdClientNameMap) {
        this.requestIdClientNameMap = requestIdClientNameMap;
    }
}

