/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

public class LogMessageUtil {
    private static final String MESSAGE_DELIMETER = "#";
    private static final String EMPTY_STRING = "";

    public static String buildMessage(String clinicalDomain, String requestId, String appName, String errorMessage) {
        if (clinicalDomain == null) {
            clinicalDomain = EMPTY_STRING;
        }
        if (requestId == null) {
            requestId = EMPTY_STRING;
        }
        if (appName == null) {
            appName = EMPTY_STRING;
        }
        if (errorMessage == null) {
            errorMessage = EMPTY_STRING;
        }
        StringBuilder message = new StringBuilder();
        message.append(MESSAGE_DELIMETER);
        message.append(clinicalDomain).append(MESSAGE_DELIMETER);
        message.append(requestId).append(MESSAGE_DELIMETER);
        message.append(appName).append(MESSAGE_DELIMETER);
        message.append(errorMessage);
        return LogMessageUtil.quotedString(message.toString());
    }

    private static String quotedString(String source) {
        if (source == null) {
            return EMPTY_STRING;
        }
        source = LogMessageUtil.replace(source, "'", "''");
        return source;
    }

    public static String replace(String source, String find, String replacement) {
        int j;
        int i = 0;
        int k = find.length();
        int m = replacement.length();
        while (i < source.length() && (j = source.indexOf(find, i)) != -1) {
            source = LogMessageUtil.replace(source, j, j + k, replacement);
            i = j + m;
        }
        return source;
    }

    public static String replace(String source, int start, int end, String replacement) {
        source = start == 0 ? replacement + source.substring(end) : (end == source.length() ? source.substring(0, start) + replacement : source.substring(0, start) + replacement + source.substring(end));
        return source;
    }

    public static String replace(String source, String find, int replacement) {
        String sReplacement = Integer.toString(replacement);
        return LogMessageUtil.replace(source, find, sReplacement);
    }
}

