/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.registry;

import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import org.apache.ws.scout.registry.infomodel.KeyImpl;

public class JAXRUtility {
    private Properties connectionProperties = null;
    private Class<ConnectionFactory> factoryClass = null;
    private ConnectionFactory connectionFactory = null;
    private Set<PasswordAuthentication> credentials = null;

    public Connection createJaxrConnection() throws JAXRException {
        try {
            if (this.connectionFactory == null) {
                this.connectionFactory = this.factoryClass != null ? this.factoryClass.newInstance() : ConnectionFactory.newInstance();
            }
            this.connectionFactory.setProperties(this.connectionProperties);
            Connection connection = this.connectionFactory.createConnection();
            if (this.credentials != null) {
                connection.setCredentials(this.credentials);
            }
            return connection;
        }
        catch (Exception e) {
            throw new JAXRException("An error occurred while creating JAXR connection.", (Throwable)e);
        }
    }

    public void closeJaxrConnection(Connection connection) throws JAXRException {
        if (connection != null) {
            connection.close();
        }
    }

    public URL findServiceEndpoint(String organizationName, String serviceName) throws JAXRException {
        Connection connection = null;
        Organization organization = null;
        ServiceBinding serviceBinding = null;
        try {
            connection = this.createJaxrConnection();
            RegistryService regSvc = connection.getRegistryService();
            BusinessQueryManager bqm = regSvc.getBusinessQueryManager();
            organization = this.getOrganizationByName(bqm, organizationName);
            serviceBinding = this.getServiceBinding(organization, serviceName);
            URL uRL = new URL(serviceBinding.getAccessURI());
            return uRL;
        }
        catch (MalformedURLException ex) {
            throw new JAXRException(String.format("The service binding access URI (%s) is malformed. Please correction the issue and retry.", serviceBinding.getAccessURI()));
        }
        finally {
            this.closeJaxrConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service registerService(String organizationName, String serviceName, String endpointUrl) throws JAXRException {
        Connection connection = null;
        try {
            connection = this.createJaxrConnection();
            RegistryService regSvc = connection.getRegistryService();
            BusinessQueryManager bqm = regSvc.getBusinessQueryManager();
            BusinessLifeCycleManager blm = regSvc.getBusinessLifeCycleManager();
            Organization organization = this.getOrganizationByName(bqm, organizationName);
            ServiceBinding serviceBinding = blm.createServiceBinding();
            serviceBinding.setAccessURI(endpointUrl);
            Service service = blm.createService(serviceName);
            service.addServiceBinding(serviceBinding);
            organization.addService(service);
            ArrayList<Organization> organzations = new ArrayList<Organization>();
            organzations.add(organization);
            blm.saveOrganizations(organzations);
            Service service2 = service;
            return service2;
        }
        finally {
            this.closeJaxrConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassificationScheme findClassificationScheme(String classificationSchemeName) throws JAXRException {
        Connection connection = null;
        try {
            ClassificationScheme cs;
            connection = this.createJaxrConnection();
            RegistryService regSvc = connection.getRegistryService();
            BusinessQueryManager bqm = regSvc.getBusinessQueryManager();
            ArrayList<String> findQualifiers = new ArrayList<String>();
            findQualifiers.add("exactNameMatch");
            ClassificationScheme classificationScheme = cs = bqm.findClassificationSchemeByName(findQualifiers, classificationSchemeName);
            return classificationScheme;
        }
        finally {
            this.closeJaxrConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ClassificationScheme> findClassificationSchemes(String classificationSchemeName) throws JAXRException {
        Connection connection = null;
        try {
            connection = this.createJaxrConnection();
            RegistryService regSvc = connection.getRegistryService();
            BusinessQueryManager bqm = regSvc.getBusinessQueryManager();
            ArrayList<String> findQualifiers = new ArrayList<String>();
            findQualifiers.add("sortByNameAsc");
            ArrayList<String> namePatterns = new ArrayList<String>();
            namePatterns.add(classificationSchemeName);
            BulkResponse br = bqm.findClassificationSchemes(findQualifiers, namePatterns, null, null);
            Collection collection = br.getCollection();
            return collection;
        }
        finally {
            this.closeJaxrConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassificationScheme createClassificationScheme(String classificationSchemName, String classificationSchemDescription) throws JAXRException {
        Connection connection = null;
        try {
            connection = this.createJaxrConnection();
            RegistryService regSvc = connection.getRegistryService();
            BusinessLifeCycleManager blm = regSvc.getBusinessLifeCycleManager();
            InternationalString name = blm.createInternationalString(classificationSchemName);
            InternationalString description = blm.createInternationalString(classificationSchemDescription);
            ClassificationScheme classificationScheme = blm.createClassificationScheme(name, description);
            ArrayList<ClassificationScheme> classificationSchemes = new ArrayList<ClassificationScheme>();
            classificationSchemes.add(classificationScheme);
            BulkResponse response = blm.saveClassificationSchemes(classificationSchemes);
            if (response.getStatus() != 0) {
                Throwable cause = null;
                if (response.getExceptions() != null && response.getExceptions().size() > 0) {
                    cause = (Throwable)response.getExceptions().toArray()[0];
                }
                throw new JAXRException(String.format("An error occured while creating the classification scheme with name %s.", classificationSchemName), cause);
            }
            classificationScheme.setKey((Key)response.getCollection().toArray()[0]);
            ClassificationScheme classificationScheme2 = classificationScheme;
            return classificationScheme2;
        }
        finally {
            this.closeJaxrConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteClassificationScheme(ClassificationScheme cs) throws JAXRException {
        Connection connection = null;
        try {
            connection = this.createJaxrConnection();
            RegistryService regSvc = connection.getRegistryService();
            BusinessLifeCycleManager blm = regSvc.getBusinessLifeCycleManager();
            ArrayList<Key> cSchemesKeys = new ArrayList<Key>();
            cSchemesKeys.add(cs.getKey());
            blm.deleteClassificationSchemes(cSchemesKeys);
        }
        finally {
            this.closeJaxrConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Concept addConcept(ClassificationScheme cScheme, String conceptName, String conceptValue) throws JAXRException {
        Connection connection = null;
        try {
            connection = this.createJaxrConnection();
            RegistryService regSvc = connection.getRegistryService();
            BusinessLifeCycleManager blm = regSvc.getBusinessLifeCycleManager();
            Concept c = blm.createConcept((RegistryObject)cScheme, blm.createInternationalString(conceptName), conceptValue);
            cScheme.addChildConcept(c);
            ArrayList<ClassificationScheme> cSchemes = new ArrayList<ClassificationScheme>();
            cSchemes.add(cScheme);
            BulkResponse br = blm.saveClassificationSchemes(cSchemes);
            Concept concept = c;
            return concept;
        }
        finally {
            this.closeJaxrConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Organization addConcept(Organization organization, Concept concept) throws JAXRException {
        Connection connection = null;
        try {
            connection = this.createJaxrConnection();
            RegistryService regSvc = connection.getRegistryService();
            BusinessLifeCycleManager blm = regSvc.getBusinessLifeCycleManager();
            Classification c = blm.createClassification(concept);
            organization.addClassification(c);
            ArrayList<Organization> organizations = new ArrayList<Organization>();
            organizations.add(organization);
            BulkResponse br = blm.saveOrganizations(organizations);
            if (br != null && br.getStatus() != 0) {
                throw new JAXRException("Error adding concept classification to Organization.");
            }
            Organization organization2 = organization;
            return organization2;
        }
        finally {
            this.closeJaxrConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Organization findOrganizationByName(String organizationName) throws JAXRException {
        Connection connection = null;
        try {
            connection = this.createJaxrConnection();
            RegistryService regSvc = connection.getRegistryService();
            BusinessQueryManager bqm = regSvc.getBusinessQueryManager();
            Organization organization = this.getOrganizationByName(bqm, organizationName);
            return organization;
        }
        finally {
            this.closeJaxrConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryObject findByIdAndType(String id, String type) throws JAXRException {
        Connection connection = null;
        try {
            RegistryObject registryObject;
            connection = this.createJaxrConnection();
            RegistryService regSvc = connection.getRegistryService();
            BusinessQueryManager bqm = regSvc.getBusinessQueryManager();
            RegistryObject registryObject2 = registryObject = bqm.getRegistryObject(id, type);
            return registryObject2;
        }
        finally {
            this.closeJaxrConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findByType(String type) throws JAXRException {
        Connection connection = null;
        try {
            connection = this.createJaxrConnection();
            RegistryService regSvc = connection.getRegistryService();
            BusinessQueryManager bqm = regSvc.getBusinessQueryManager();
            BulkResponse br = bqm.getRegistryObjects(type);
            Collection collection = br.getCollection();
            return collection;
        }
        finally {
            this.closeJaxrConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Service> findServices(String orgName, String serviceName) throws JAXRException {
        Connection connection = null;
        try {
            Collection services;
            connection = this.createJaxrConnection();
            RegistryService regSvc = connection.getRegistryService();
            BusinessQueryManager bqm = regSvc.getBusinessQueryManager();
            ArrayList<String> findQualifiers = new ArrayList<String>();
            findQualifiers.add("exactNameMatch");
            ArrayList<String> namePatterns = new ArrayList<String>();
            namePatterns.add(serviceName);
            BulkResponse bulkResponse = bqm.findServices((Key)new KeyImpl(orgName), findQualifiers, namePatterns, null, null);
            Collection collection = services = bulkResponse.getCollection();
            return collection;
        }
        finally {
            this.closeJaxrConnection(connection);
        }
    }

    public URL serviceToServiceEndpointURL(Service service) throws JAXRException {
        ServiceBinding serviceBinding = null;
        try {
            if (service != null && service.getServiceBindings().size() == 1) {
                serviceBinding = service.getServiceBindings().toArray(new ServiceBinding[0])[0];
                return new URL(serviceBinding.getAccessURI());
            }
            throw new JAXRException("Unexpected number of service binding for service.");
        }
        catch (MalformedURLException e) {
            throw new JAXRException(String.format("The access URI for the service is not valid. URI: '%s'", serviceBinding.getAccessURI()));
        }
    }

    private ServiceBinding getServiceBinding(Organization organization, String serviceName) throws JAXRException {
        Collection services = organization.getServices();
        for (Service svc : services) {
            Collection bindings;
            if (!serviceName.equalsIgnoreCase(svc.getName().getValue()) || (bindings = svc.getServiceBindings()).size() != 1) continue;
            return (ServiceBinding)bindings.toArray()[0];
        }
        throw new JAXRException(String.format("Error locating service binding. [Organization Name: %s, Service Name: %s]", organization.getName().getValue(), serviceName));
    }

    private Organization getOrganizationByName(BusinessQueryManager businessQueryManager, String organizationName) throws JAXRException {
        ArrayList<String> findQualifiers = new ArrayList<String>();
        findQualifiers.add("exactNameMatch");
        ArrayList<String> namePatterns = new ArrayList<String>();
        namePatterns.add(organizationName);
        BulkResponse response = businessQueryManager.getRegistryObjects("Organization");
        Collection orgs = response.getCollection();
        for (Organization o : orgs) {
            if (!organizationName.equalsIgnoreCase(o.getName().getValue())) continue;
            return o;
        }
        throw new JAXRException("Error locating unique organzation.");
    }

    public void setConnectionProperties(Properties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public void setFactoryClass(Class factoryClass) {
        this.factoryClass = factoryClass;
    }

    public void setCredentials(Set<PasswordAuthentication> credentials) {
        this.credentials = credentials;
    }
}

