/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.monitor.util;

import java.util.Collections;
import java.util.List;

public class MetricsCalculator {
    public static double calcStandardDeviation(List<Long> measurements, int count, double mean) {
        Double sqSum = 0.0;
        for (Long measurement : measurements) {
            double variance = (double)measurement.longValue() - mean;
            sqSum = sqSum + variance * variance;
        }
        return Math.sqrt(sqSum / (double)count);
    }

    public static double calcMedian(List<Long> measurements) {
        double median = 0.0;
        Collections.sort(measurements);
        int size = measurements.size();
        if (size % 2 == 0) {
            int mid = size / 2;
            Long middle2 = measurements.get(mid);
            Long middle1 = measurements.get(--mid);
            median = (double)(middle1 + middle2) / 2.0;
        } else if (size > 1) {
            int mid = size % 2 + size / 2;
            Long middle = measurements.get(mid);
            median = middle.doubleValue();
        } else {
            median = measurements.get(0).longValue();
        }
        return median;
    }

    public static double getTransactionsPerSecond(long count, long elapsedTime) {
        return MetricsCalculator.getTransactionsPerSecond(count, (double)elapsedTime);
    }

    public static double getTransactionsPerSecond(long count, double elapsedTime) {
        return (double)count * 1000.0 / elapsedTime;
    }
}

