/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.client.proxy;

import gov.va.med.cds.client.proxy.GetReadWriteChannel;
import gov.va.med.cds.client.proxy.IBlockingConnectionFactory;
import gov.va.med.cds.client.proxy.NetworkClientProxyInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.SocketClientException;
import gov.va.med.cds.util.MllpUtil;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMllpSocketBasedClientProxy
implements NetworkClientProxyInterface {
    private static Log logger = LogFactory.getLog(AbstractMllpSocketBasedClientProxy.class);
    IBlockingConnectionFactory blockingConnectionFactory = null;
    public GetReadWriteChannel getReadWriteChannel = null;
    public int port;

    public void setGetReadWriteChannel(GetReadWriteChannel getReadWriteChannel) {
        this.getReadWriteChannel = getReadWriteChannel;
    }

    @Override
    public abstract ByteBuffer sendMessage(ByteBuffer var1, Properties var2);

    @Override
    public String sendMessage(String message, Properties properties) {
        ByteBuffer msgBuffer = ByteBuffer.wrap(message.getBytes());
        ByteBuffer respBuffer = this.sendMessage(msgBuffer, properties);
        String response = new String(respBuffer.array());
        return response;
    }

    public ByteBuffer sendMessage(ByteBuffer acknowledgement, String host) {
        ByteBuffer response = null;
        SocketChannel socketChannel = null;
        WritableByteChannel wrappedWritableByteChannel = null;
        ReadableByteChannel wrappedReadableByteChannel = null;
        try {
            socketChannel = this.blockingConnectionFactory.getConnection(host, this.port);
            wrappedWritableByteChannel = this.getReadWriteChannel.getWriteChannel(socketChannel);
            wrappedWritableByteChannel.write(MllpUtil.encode(acknowledgement, Charset.defaultCharset(), Charset.forName("ISO-8859-1")));
            ByteBuffer buffer = ByteBuffer.allocate(2048);
            wrappedReadableByteChannel = this.getReadWriteChannel.getReadChannel(socketChannel);
            wrappedReadableByteChannel.read(buffer);
            buffer.flip();
            response = MllpUtil.decode(new ByteBuffer[]{buffer}, Charset.forName("ISO-8859-1"), Charset.defaultCharset());
        }
        catch (Exception e) {
            logger.error((Object)"Socket timeout exception occurred when writing message ", (Throwable)e);
            throw new SocketClientException(ErrorCodeEnum.SOCKET_CLIENT_TIMEOUT_EXCEPTION, (Throwable)e);
        }
        finally {
            try {
                socketChannel.socket().close();
                socketChannel.close();
            }
            catch (Exception e) {
                logger.error((Object)"Error closing connection.", (Throwable)e);
            }
        }
        return response;
    }

    public void setBlockingConnectionFactory(IBlockingConnectionFactory blockingConnectionFactory) {
        this.blockingConnectionFactory = blockingConnectionFactory;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

