/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.audit;

import gov.va.med.cds.audit.AbstractAuditLog;
import gov.va.med.cds.audit.ClientMappingPathways;
import gov.va.med.cds.audit.FilterIdWrapper;
import gov.va.med.cds.audit.TemplateIdWrapper;
import gov.va.med.cds.util.DateTimeUtil;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class VhimReadPathwaysResponseAuditLog
extends AbstractAuditLog {
    private static final Log logger = LogFactory.getLog(VhimReadPathwaysResponseAuditLog.class);
    private static final long serialVersionUID = 1L;
    protected static final String ADD_NEW_LINE = "\n";
    protected static final String ADD_TAB = "\t";
    protected static final String ADD_DOUBLE_TAB = "\t\t";
    private static final String PATHWAYS_DOMAIN_NAME = "PATHWAYS 1.x";
    private String pathwaysDomainName = "PATHWAYS 1.x";
    private Long auditLogId;
    private Date localTime;
    protected String isoLocalTime = DateTimeUtil.getISOTime(new Date().getTime(), null);
    private ClientMappingPathways clientMappingPathways;
    protected String clientId;
    protected String clientRequestInitiationTime;
    private TemplateIdWrapper templateIdWrapper = new TemplateIdWrapper();
    private FilterIdWrapper filterIdWrapper = new FilterIdWrapper();
    protected String filterRequest;
    protected Long clientMappingId;
    private String facility;
    private String response;
    protected long startTime;
    protected long endTime;
    private long milliseconds;
    protected String requestId;
    protected String sendingApplication;
    protected String debugInfo;
    private int responseSize = -1;
    private int responseLength = -1;
    private String appName;

    @Override
    public String getDebugInfo() {
        StringBuilder auditInfo = new StringBuilder();
        auditInfo.append("Server PATHWAYS 1.x ==> Audit detail: ");
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_TAB);
        auditInfo.append("domain => ");
        auditInfo.append(PATHWAYS_DOMAIN_NAME);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_TAB);
        auditInfo.append("start_milliseconds => ");
        auditInfo.append(this.startTime);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_TAB);
        auditInfo.append("milliseconds => ");
        auditInfo.append(this.getMilliseconds());
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_TAB);
        auditInfo.append("ISO_localtime => ");
        auditInfo.append(this.isoLocalTime);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_TAB);
        auditInfo.append("log_information => ");
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_DOUBLE_TAB);
        auditInfo.append("startTime -> ");
        auditInfo.append(this.startTime);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_DOUBLE_TAB);
        auditInfo.append("sendingApplication -> ");
        auditInfo.append(this.sendingApplication);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_DOUBLE_TAB);
        auditInfo.append("originalMessageControlId -> ");
        auditInfo.append(this.requestId);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_DOUBLE_TAB);
        auditInfo.append("requesterString -> ");
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_DOUBLE_TAB);
        auditInfo.append("requestMsg -> ");
        auditInfo.append(this.filterRequest);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_DOUBLE_TAB);
        auditInfo.append("receivingApplication -> ");
        auditInfo.append(PATHWAYS_DOMAIN_NAME);
        auditInfo.append(ADD_NEW_LINE);
        auditInfo.append(ADD_DOUBLE_TAB);
        auditInfo.append("completionTime -> ");
        auditInfo.append(Long.toString(this.endTime));
        this.debugInfo = auditInfo.toString();
        return this.debugInfo;
    }

    @Override
    public void setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
        Map<String, String> debugInfoMap = this.parseDebugInfo(debugInfo);
        this.setStartTime(Long.parseLong(debugInfoMap.get("start_milliseconds")));
        this.setMilliseconds(Long.parseLong(debugInfoMap.get("milliseconds")));
        this.setIsoLocalTime(debugInfoMap.get("ISO_localtime"));
        this.setSendingApplication(debugInfoMap.get("sendingApplication"));
        this.setRequestId(debugInfoMap.get("originalMessageControlId"));
        this.setFilterRequest(debugInfoMap.get("requestMsg"));
        this.setEndTime(Long.parseLong(debugInfoMap.get("completionTime")));
    }

    @Override
    protected int getResponseLength(String response) {
        this.responseLength = 0;
        if (response == null) {
            return this.responseLength;
        }
        try {
            Document document = DocumentHelper.parseText((String)response);
            Element rootElement = document.getRootElement();
            if (rootElement.element("patients") != null) {
                Iterator patientIterator = rootElement.element("patients").elementIterator("patient");
                while (patientIterator.hasNext()) {
                    Element patientElement = (Element)patientIterator.next();
                    this.responseLength += patientElement.selectNodes("//exams/exam").size();
                    this.responseLength += patientElement.selectNodes("//examRequests/examRequest").size();
                    this.responseLength += patientElement.selectNodes("//appointments/appointment").size();
                    this.responseLength += patientElement.selectNodes("//releasesOfInformation/releaseOfInformation").size();
                    this.responseLength += patientElement.selectNodes("//clinicalReminders/clinicalReminder").size();
                }
            }
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("Invalid document string passed in.", e);
        }
        return this.responseLength;
    }

    @Override
    public int getResponseLength() {
        if (this.response != null) {
            return this.getResponseLength(this.response);
        }
        return this.responseLength;
    }

    @Override
    public int getResponseSize() {
        this.responseSize = this.getResponse() != null ? this.getResponse().getBytes().length : 0;
        return this.responseSize;
    }

    @Override
    public void setResponseLength(int responseLength) {
        this.responseLength = responseLength;
    }

    @Override
    public void setResponseSize(int responseSize) {
        this.responseSize = responseSize;
    }

    public String getPathwaysDomainName() {
        return this.pathwaysDomainName;
    }

    public void setPathwaysDomainName(String pathwaysDomainName) {
        this.pathwaysDomainName = pathwaysDomainName;
    }

    @Override
    public Long getAuditLogId() {
        return this.auditLogId;
    }

    private void setAuditLogId(Long auditLogId) {
        this.auditLogId = auditLogId;
    }

    @Override
    public long getMilliseconds() {
        this.milliseconds = this.endTime - this.startTime;
        return this.milliseconds;
    }

    @Override
    public void setMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    @Override
    public String getDomainName() {
        return PATHWAYS_DOMAIN_NAME;
    }

    public ClientMappingPathways getClientMappingPathways() {
        return this.clientMappingPathways;
    }

    public void setClientMappingPathways(ClientMappingPathways clientMappingPathways) {
        this.clientMappingPathways = clientMappingPathways;
    }

    @Override
    public String getFilterId() {
        return this.filterIdWrapper.getFilterId();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Long getClientMappingId() {
        return this.clientMappingPathways.getClientMappingId();
    }

    public void setClientMappingId(Long clientMappingId) {
        this.clientMappingPathways.setClientMappingId(clientMappingId);
    }

    @Override
    public String getTemplateId() {
        return this.templateIdWrapper.getTemplateId();
    }

    @Override
    public void setTemplateId(String aTemplateId) {
        this.templateIdWrapper.setTemplateId(aTemplateId);
        if (this.clientMappingPathways == null) {
            this.clientMappingPathways = new ClientMappingPathways(null, aTemplateId);
        } else {
            this.clientMappingPathways.setTemplateId(aTemplateId);
        }
    }

    @Override
    public void setFilterId(String aFilterId) {
        this.filterIdWrapper.setFilterId(aFilterId);
        if (this.clientMappingPathways == null) {
            this.clientMappingPathways = new ClientMappingPathways(aFilterId, null);
        } else {
            this.clientMappingPathways.setFilterId(aFilterId);
        }
    }

    @Override
    protected Map<String, String> parseDebugInfo(String debugInfo) {
        String[] infos;
        Hashtable<String, String> data = new Hashtable<String, String>();
        String delim = "=>";
        debugInfo = debugInfo.substring(debugInfo.indexOf("Audit detail: ") + "Audit detail: ".length());
        for (String info : infos = debugInfo.split(ADD_NEW_LINE)) {
            if ((info = info.trim()).startsWith("Server")) continue;
            if (info.startsWith("log_information")) {
                delim = "->";
                continue;
            }
            String[] arr = info.split(delim);
            data.put(arr[0].trim(), arr.length == 2 ? arr[1].trim() : "");
        }
        return data;
    }

    @Override
    public Date getLocalTime() {
        return this.localTime;
    }

    @Override
    public void setLocalTime(Date localTime) {
        this.localTime = localTime;
    }

    @Override
    public String getFacility() {
        return this.facility;
    }

    @Override
    public void setFacility(String facility) {
        this.facility = facility;
    }

    @Override
    public String getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(String response) {
        this.response = response;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Override
    public String getIsoLocalTime() {
        return this.isoLocalTime;
    }

    @Override
    public void setIsoLocalTime(String isoLocalTime) {
        this.isoLocalTime = isoLocalTime;
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Override
    public String getSendingApplication() {
        return this.sendingApplication;
    }

    @Override
    public void setSendingApplication(String sendingApplication) {
        this.sendingApplication = sendingApplication;
    }

    @Override
    public String getFilterRequest() {
        return this.filterRequest;
    }

    @Override
    public void setFilterRequest(String filterRequest) {
        this.filterRequest = filterRequest;
        try {
            Document filterDocument = DocumentHelper.parseText((String)filterRequest);
            this.setClientId(filterDocument.getRootElement().elementTextTrim("clientName"));
            this.setClientRequestInitiationTime(filterDocument.getRootElement().elementTextTrim("clientRequestInitiationTime"));
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("Filter request document is not valid XML.", e);
        }
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public TemplateIdWrapper getTemplateIdWrapper() {
        return this.templateIdWrapper;
    }

    @Override
    public void setTemplateIdWrapper(TemplateIdWrapper templateIdWrapper) {
        this.templateIdWrapper = templateIdWrapper;
    }

    @Override
    public FilterIdWrapper getFilterIdWrapper() {
        return this.filterIdWrapper;
    }

    @Override
    public void setFilterIdWrapper(FilterIdWrapper filterIdWrapper) {
        this.filterIdWrapper = filterIdWrapper;
    }

    @Override
    public String getClientRequestInitiationTime() {
        return this.clientRequestInitiationTime;
    }

    @Override
    public void setClientRequestInitiationTime(String clientRequestInitiationTime) {
        this.clientRequestInitiationTime = clientRequestInitiationTime;
    }
}

