/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

import gov.va.med.cds.util.LogMessageUtil;
import gov.va.med.cds.util.StreamUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.XMLWriter;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class XmlStringOperations {
    private static Log logger = LogFactory.getLog(XmlStringOperations.class);
    private static final String APPLICATION_NAME = "CDS";

    public String xmlToString(String filepath) throws IOException {
        filepath = filepath.replace('\\', File.separatorChar);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)LogMessageUtil.buildMessage(null, null, APPLICATION_NAME, "Loading Xml as string data from file : " + filepath));
        }
        FileSystemResource fileSystemResource = new FileSystemResource(filepath);
        String resource = StreamUtil.resourceToString((Resource)fileSystemResource);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)LogMessageUtil.buildMessage(null, null, APPLICATION_NAME, "Xml from file : \n" + resource));
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String xmlStringToXmlFile(String xmlAsString, String operation, String outputFile) {
        FileWriter fileWriter = null;
        XMLWriter xmlWriter = null;
        try {
            Document document = DocumentHelper.parseText((String)xmlAsString);
            fileWriter = new FileWriter(outputFile);
            xmlWriter = new XMLWriter((Writer)fileWriter);
            xmlWriter.write(document);
            xmlWriter.close();
        }
        catch (DocumentException de) {
            logger.error((Object)LogMessageUtil.buildMessage(null, null, APPLICATION_NAME, "Cannot convert  String to Xml : " + de.getStackTrace()));
        }
        catch (IOException ioe) {
            logger.error((Object)LogMessageUtil.buildMessage(null, null, APPLICATION_NAME, "Cannot convert  String to Xml : " + ioe.getStackTrace()));
        }
        finally {
            if (xmlWriter != null) {
                try {
                    xmlWriter.close();
                }
                catch (IOException de) {}
            }
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException de) {}
            }
        }
        return outputFile;
    }
}

