/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeUtil {
    public static final String FORMAT_FULL = "yyyyMMddHHmmss.SSS";
    public static final String FORMAT_PARTIAL = "yyyMddHHmm";
    public static final String FORMAT_DATE_TIME = "yyyyMMdd.HHmmss";
    public static final String FORMAT_TZ = "Z";
    public static final String FORMAT_HL7 = "yyyyMMddHHmmssZ";
    public static final String FORMAT_DATE_STR = "MM/dd/yyyy";

    public static String getISOTime(long milliseconds, TimeZone timezone) {
        String format = "yyyyMMddHHmmss.SSSZ";
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
        if (null != timezone) {
            df.setTimeZone(timezone);
        }
        return df.format(new Date(milliseconds));
    }

    public static String getPartialISOTime(long milliseconds, TimeZone timezone) {
        String format = FORMAT_PARTIAL;
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_PARTIAL);
        if (null != timezone) {
            df.setTimeZone(timezone);
        }
        return df.format(new Date(milliseconds));
    }

    public static String getDateTimeDotSeparated(long milliseconds, TimeZone timezone) {
        String format = FORMAT_DATE_TIME;
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_DATE_TIME);
        if (null != timezone) {
            df.setTimeZone(timezone);
        }
        return df.format(new Date(milliseconds));
    }

    public static String stripTimeZoneOffset(String timeStamp) {
        return timeStamp.substring(0, timeStamp.indexOf("."));
    }

    public static String getCurrentDateTime(String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date date = new Date();
        return dateFormat.format(date);
    }

    public static boolean isDateValidHl7Format(String messageDateTime) {
        boolean isValid = true;
        try {
            if (messageDateTime.matches("([0-9]{14})-([0-9]{4})")) {
                String format = FORMAT_HL7;
                SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_HL7);
                sdf.setLenient(false);
                Date date = sdf.parse(messageDateTime);
            } else {
                isValid = false;
            }
        }
        catch (Exception eD) {
            isValid = false;
        }
        return isValid;
    }

    public static String convertDate2String(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT_DATE_STR);
        return dateFormat.format(date);
    }
}

