/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

import gov.va.med.cds.exception.EncryptionException;
import gov.va.med.cds.exception.ErrorCodeEnum;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class CipherUtilities {
    public static final String ENCRYPTED_PREFIX = "{AES}";
    private static final String ENCRYPTION_ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final SecureRandom random = new SecureRandom();
    private static final byte[] iv = random.generateSeed(16);
    private static final IvParameterSpec ivspec = new IvParameterSpec(iv);

    public static SecretKey generateKey() {
        KeyGenerator kgen = null;
        try {
            kgen = KeyGenerator.getInstance(ENCRYPTION_ALGORITHM);
            kgen.init(128);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_MISSING_KEYSTORE_FILEPATH_EXCEPTION);
        }
        return kgen.generateKey();
    }

    public static SecretKeySpec generateKeySpec() {
        SecretKey skey = CipherUtilities.generateKey();
        byte[] raw = skey.getEncoded();
        return new SecretKeySpec(raw, ENCRYPTION_ALGORITHM);
    }

    public static SecretKeySpec generateKeySpec(SecretKey aSecretKey) {
        byte[] raw = aSecretKey.getEncoded();
        return new SecretKeySpec(raw, ENCRYPTION_ALGORITHM);
    }

    public static SecretKeySpec configureKeyStore(String aKeyStoreFileLocation, String aKeyStorePassword) throws IOException {
        FileInputStream fileInStream = null;
        KeyStore kstore = null;
        if (aKeyStorePassword == null) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_MISSING_KEYSTORE_PASSWORD_EXCEPTION);
        }
        if (aKeyStoreFileLocation == null) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_MISSING_KEYSTORE_FILEPATH_EXCEPTION);
        }
        try {
            kstore = KeyStore.getInstance("JCEKS");
            char[] password = aKeyStorePassword.toCharArray();
            fileInStream = new FileInputStream(aKeyStoreFileLocation);
            kstore.load(fileInStream, password);
        }
        catch (KeyStoreException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        catch (CertificateException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        finally {
            if (fileInStream != null) {
                fileInStream.close();
            }
        }
        return CipherUtilities.retrieveKeyEntry(aKeyStoreFileLocation, aKeyStorePassword, kstore);
    }

    private static SecretKeySpec retrieveKeyEntry(String aKeyStoreFileLocation, String aKeyStorePassword, KeyStore aKeyStore) throws IOException {
        FileOutputStream fos = null;
        KeyStore.PasswordProtection kp = new KeyStore.PasswordProtection(aKeyStorePassword.toCharArray());
        SecretKey secretKey = null;
        KeyStore.SecretKeyEntry secretEntry = null;
        try {
            secretEntry = (KeyStore.SecretKeyEntry)aKeyStore.getEntry("secretKeyAlias", kp);
            if (secretEntry == null) {
                secretKey = CipherUtilities.generateKey();
                KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(secretKey);
                aKeyStore.setEntry("secretKeyAlias", skEntry, kp);
                fos = new FileOutputStream(aKeyStoreFileLocation);
                aKeyStore.store(fos, aKeyStorePassword.toCharArray());
            } else {
                secretKey = secretEntry.getSecretKey();
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        catch (UnrecoverableEntryException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        catch (CertificateException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        return CipherUtilities.generateKeySpec(secretKey);
    }

    public static String encrypt(SecretKeySpec aSecretKeySpec, String aStringToEncrypt) {
        return CipherUtilities.encrypt(aSecretKeySpec, aStringToEncrypt, true);
    }

    public static String encrypt(SecretKeySpec aSecretKeySpec, String aStringToEncrypt, boolean aAddPrefixFlag) {
        byte[] encrypted = null;
        try {
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            cipher.init(1, aSecretKeySpec);
            byte[] in = aStringToEncrypt.getBytes();
            encrypted = cipher.doFinal(in);
        }
        catch (InvalidKeyException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        catch (BadPaddingException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        String encryptedString = Base64.encodeBase64String((byte[])encrypted);
        if (aAddPrefixFlag) {
            encryptedString = ENCRYPTED_PREFIX + encryptedString;
        }
        return encryptedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encryptAndSaveProperties(Properties aProperties, SecretKeySpec aSecretKeySpec, String aPropertyFilePath) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(aPropertyFilePath));
        Properties propsToBeSaved = (Properties)aProperties.clone();
        Enumeration<?> e = propsToBeSaved.propertyNames();
        String propKey = (String)e.nextElement();
        if (propKey.endsWith(".password")) {
            String propValue = propsToBeSaved.getProperty(propKey);
            propsToBeSaved.setProperty(propKey, CipherUtilities.encrypt(aSecretKeySpec, propValue));
        }
        try {
            propsToBeSaved.store(fos, "File encrypted");
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static String encrypt(String aStringToEncrypt, byte[] aKey) throws NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return CipherUtilities.encrypt(aStringToEncrypt, aKey, iv);
    }

    public static String encrypt(String aStringToEncrypt, byte[] aKey, byte[] anInitializationVector) throws NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        String encodedResult = null;
        SecretKeySpec secretKeySpec = new SecretKeySpec(aKey, ENCRYPTION_ALGORITHM);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(anInitializationVector);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        byte[] encryptedData = cipher.doFinal(aStringToEncrypt.getBytes());
        encodedResult = Base64.encodeBase64String((byte[])encryptedData);
        return encodedResult;
    }

    public static String decrypt(SecretKeySpec aSecretKeySpec, String aStringToDecrypt) {
        String decryptedString = null;
        if (CipherUtilities.isEncrypted(aStringToDecrypt)) {
            aStringToDecrypt = CipherUtilities.removePrefix(aStringToDecrypt);
            try {
                Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
                cipher.init(2, aSecretKeySpec);
                byte[] in = Base64.decodeBase64((String)aStringToDecrypt);
                byte[] bitesOut = cipher.doFinal(in);
                decryptedString = new String(bitesOut);
            }
            catch (NoSuchAlgorithmException e) {
                throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
            }
            catch (NoSuchPaddingException e) {
                throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
            }
            catch (InvalidKeyException e) {
                throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
            }
            catch (IllegalBlockSizeException e) {
                throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
            }
            catch (BadPaddingException e) {
                throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
            }
            return decryptedString;
        }
        return aStringToDecrypt;
    }

    public static String decrypt(byte[] aKey, String aStringToDecrypt) {
        return CipherUtilities.decrypt(aKey, iv, aStringToDecrypt);
    }

    public static String decrypt(byte[] aKey, byte[] anInitializationVector, String aStringToDecrypt) {
        String decryptedString = null;
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(aKey, ENCRYPTION_ALGORITHM);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(anInitializationVector);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            byte[] in = Base64.decodeBase64((String)aStringToDecrypt);
            byte[] bitesOut = cipher.doFinal(in);
            decryptedString = new String(bitesOut);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        catch (BadPaddingException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EncryptionException(ErrorCodeEnum.ENCRYPTION_EXCEPTION, (Throwable)e);
        }
        return decryptedString;
    }

    public static boolean isEncrypted(String anEncryptedString) {
        return anEncryptedString.startsWith(ENCRYPTED_PREFIX);
    }

    private static String removePrefix(String anEncryptedString) {
        return anEncryptedString.replace(ENCRYPTED_PREFIX, "");
    }
}

