/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.properties;

import gov.va.med.cds.util.CipherUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;

public class PropertiesManager {
    public static final String PROPERTIES_FILE_PATH_PROPERTY = "cds.run.properties.path";
    public static final String PROPERTIES_ENCRYPTION_SWITCH = "cds.encrypt.password.properties";
    public static final String PROPERTIES_KEYSTORE_PSWD = "cds.keystore.password";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadPropertiesFromPropertiesFile(String propertiesFilePath) throws FileNotFoundException, IOException {
        Properties fileProps = new Properties();
        try (FileInputStream propInputStream = null;){
            propInputStream = new FileInputStream(propertiesFilePath);
            fileProps.load(propInputStream);
            ((InputStream)propInputStream).close();
        }
        return fileProps;
    }

    protected String getKeyStorePasswordFromSystemProperties() {
        String keyStorePassword = System.getProperty(PROPERTIES_KEYSTORE_PSWD);
        return keyStorePassword;
    }

    protected String getEncryptSwitchFromSystemProperties() {
        String encrypt = System.getProperty(PROPERTIES_ENCRYPTION_SWITCH);
        return encrypt;
    }

    protected String getPropertiesFilePathFromSystemProperties() {
        String propertiesFilePath = System.getProperty(PROPERTIES_FILE_PATH_PROPERTY);
        return propertiesFilePath;
    }

    protected void updateSystemProperties(Properties fileProps) {
        Properties systemProps = System.getProperties();
        systemProps.putAll((Map<?, ?>)fileProps);
        System.setProperties(systemProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encryptProperties(SecretKeySpec savedKey, String propertiesFilePath, Properties propsToBeSaved) throws IOException {
        FileOutputStream fos = null;
        Enumeration<?> e = propsToBeSaved.propertyNames();
        while (e.hasMoreElements()) {
            String propValue;
            String propKey = (String)e.nextElement();
            if (!propKey.endsWith(".password") || CipherUtilities.isEncrypted(propValue = propsToBeSaved.getProperty(propKey))) continue;
            propsToBeSaved.setProperty(propKey, CipherUtilities.encrypt(savedKey, propValue));
        }
        fos = new FileOutputStream(new File(propertiesFilePath));
        try {
            propsToBeSaved.store(fos, "File encrypted");
            fos.close();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    protected Properties decryptProperties(SecretKeySpec savedKey, String keyStoreFileLocation, String keyStorePassword, Properties fileProps) throws IOException {
        Enumeration<?> e = fileProps.propertyNames();
        while (e.hasMoreElements()) {
            String propValue;
            String propKey = (String)e.nextElement();
            if (!propKey.endsWith(".password") || !(propValue = fileProps.getProperty(propKey)).startsWith("{AES}")) continue;
            if (savedKey == null) {
                savedKey = this.configureKeyStore(keyStoreFileLocation, keyStorePassword);
            }
            fileProps.setProperty(propKey, this.decrypt(savedKey, propValue));
        }
        return fileProps;
    }

    protected String decrypt(SecretKeySpec savedKey, String propValue) {
        return CipherUtilities.decrypt(savedKey, propValue);
    }

    protected SecretKeySpec configureKeyStore(String keyStoreFileLocation, String keyStorePassword) throws IOException {
        return CipherUtilities.configureKeyStore(keyStoreFileLocation, keyStorePassword);
    }
}

