/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.monitor;

import gov.va.med.cds.monitor.MethodMetricsInterface;
import gov.va.med.cds.monitor.util.MetricsCalculator;

public abstract class AbstractMethodMetrics
implements MethodMetricsInterface {
    private boolean collectionEnabled = false;
    private long methodCount = 0L;
    private long methodElapsedTime = 0L;
    private long minElapsedTime = Long.MAX_VALUE;
    private long maxElapsedTime = Long.MIN_VALUE;
    private double averageElapsedTime = 0.0;
    private double transactionsPerSecond = 0.0;

    @Override
    public boolean isCollectionEnabled() {
        return this.collectionEnabled;
    }

    private synchronized void setCollectionEnabled(boolean enabled) {
        if (enabled) {
            this.resetMetrics();
        }
        this.collectionEnabled = enabled;
    }

    @Override
    public synchronized void enableMetrics() {
        this.setCollectionEnabled(true);
    }

    @Override
    public synchronized void disableMetrics() {
        this.setCollectionEnabled(false);
    }

    @Override
    public synchronized void resetMetrics() {
        this.methodCount = 0L;
        this.methodElapsedTime = 0L;
        this.minElapsedTime = Long.MAX_VALUE;
        this.maxElapsedTime = Long.MIN_VALUE;
        this.averageElapsedTime = 0.0;
        this.transactionsPerSecond = 0.0;
    }

    public synchronized void setSingleMethodElapsedTime(long elapsedTime) {
        if (this.collectionEnabled) {
            this.methodElapsedTime += elapsedTime;
            ++this.methodCount;
            this.averageElapsedTime = (double)this.methodElapsedTime / (double)this.methodCount;
            this.transactionsPerSecond = MetricsCalculator.getTransactionsPerSecond(this.methodCount, this.methodElapsedTime);
            this.minElapsedTime = Math.min(this.minElapsedTime, elapsedTime);
            this.maxElapsedTime = Math.max(this.maxElapsedTime, elapsedTime);
        }
    }

    protected long getTransactions() {
        return this.methodCount;
    }

    protected long getElapsedTime() {
        return this.methodElapsedTime;
    }

    protected double getTransactionsPerSecond() {
        return this.transactionsPerSecond;
    }

    protected double getAverageElapsedTime() {
        return this.averageElapsedTime;
    }

    protected long getMaxElapsedTime() {
        return this.maxElapsedTime;
    }

    protected long getMinElapsedTime() {
        return this.minElapsedTime;
    }
}

