/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.exceptionframework;

import gov.va.med.cds.exceptionframework.ExceptionInfo;
import gov.va.med.cds.exceptionframework.LoggingSeverity;
import gov.va.med.cds.util.LogMessageUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

public class ExceptionUtil {
    private static final int INIT_BUFFER_SIZE = 4500;

    public static void logException(List<ExceptionInfo> e, LoggingSeverity loggingSeverity, Log logger, String entryPoint, String requestId, String applicationName) {
        ExceptionUtil.logException(e, loggingSeverity, logger, null, entryPoint, requestId, applicationName);
    }

    public static void logException(Exception exception, Log logger, String message, String entryPoint, String requestId, String applicationName) {
        ExceptionUtil.logException(exception, LoggingSeverity.FATAL, logger, message, entryPoint, requestId, applicationName);
    }

    public static void logException(ExceptionInfo e, Log logger, String message, String entryPoint, String requestId, String applicationName) {
        ArrayList<ExceptionInfo> exceptionInfoList = new ArrayList<ExceptionInfo>();
        exceptionInfoList.add(e);
        ExceptionUtil.logException(exceptionInfoList, LoggingSeverity.FATAL, logger, message, entryPoint, requestId, applicationName);
    }

    private static void logException(List<ExceptionInfo> e, LoggingSeverity loggingSeverity, Log logger, String message, String entryPoint, String requestId, String applicationName) {
        for (ExceptionInfo exceptionInfo : e) {
            String exceptionTrace = ExceptionUtil.getExceptionLog(exceptionInfo, message, requestId);
            ExceptionUtil.logMessage(logger, loggingSeverity, LogMessageUtil.buildMessage(entryPoint, requestId, applicationName, exceptionTrace), exceptionInfo.getException());
        }
    }

    public static void logException(Exception exception, LoggingSeverity loggingSeverity, Log logger, String message, String entryPoint, String requestId, String applicationName) {
        String exceptionTrace = ExceptionUtil.getExceptionLog(exception, message, requestId);
        ExceptionUtil.logMessage(logger, loggingSeverity, LogMessageUtil.buildMessage(entryPoint, requestId, applicationName, exceptionTrace), exception);
    }

    private static void logMessage(Log logger, LoggingSeverity loggingSeverity, String message, Throwable exception) {
        switch (loggingSeverity) {
            case WARNING: {
                logger.warn((Object)message, exception);
                break;
            }
            case ERROR: {
                logger.error((Object)message, exception);
                break;
            }
            default: {
                logger.fatal((Object)message, exception);
            }
        }
    }

    private static void logMessage(Log logger, LoggingSeverity loggingSeverity, Object message) {
        switch (loggingSeverity) {
            case WARNING: {
                logger.warn(message);
                break;
            }
            case ERROR: {
                logger.error(message);
                break;
            }
            default: {
                logger.fatal(message);
            }
        }
    }

    private static String getExceptionLog(ExceptionInfo exception, String message, String requestId) {
        StringBuilder logMessage = new StringBuilder(4500);
        logMessage.append(exception.getClass().getName()).append(",");
        logMessage.append(message).append(",");
        try {
            if (!exception.getClientMessage().equals(null)) {
                logMessage.append(exception.getException() + " " + exception.getClientMessage()).append(",");
            }
        }
        catch (NullPointerException npe) {
            logMessage.append(exception.getExceptionMessage()).append(",");
        }
        logMessage.append(requestId).append(",");
        logMessage.append(ExceptionUtil.getDetailedMessage(exception.getException()));
        return logMessage.toString();
    }

    private static String getExceptionLog(Exception exception, String message, String requestId) {
        StringBuilder logMessage = new StringBuilder(4500);
        logMessage.append(exception.getClass().getName()).append(",");
        logMessage.append(message).append(",");
        try {
            if (message != null) {
                logMessage.append(exception + " " + message).append(",");
            }
        }
        catch (NullPointerException npe) {
            logMessage.append(exception.getMessage()).append(",");
        }
        logMessage.append(requestId).append(",");
        logMessage.append(ExceptionUtil.getDetailedMessage(exception));
        return logMessage.toString();
    }

    private static StringBuffer getDetailedMessage(Throwable exception) {
        StringBuffer detailedMessage = new StringBuffer();
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            detailedMessage.append(sw.toString());
            pw.close();
            sw.close();
        }
        catch (Exception e) {
            detailedMessage.append(e.toString());
        }
        return detailedMessage;
    }

    public static String formatMessage(String userMessage, String[] dataValues) {
        if (dataValues != null && dataValues.length > 0) {
            MessageFormat messageFormat = new MessageFormat(userMessage);
            userMessage = messageFormat.format(dataValues);
        }
        return userMessage;
    }
}

