/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;

public class StringUtil {
    public static String stripNewlines(String source) {
        if (source == null) {
            return null;
        }
        StringBuilder buff = new StringBuilder(source.length());
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == '\n') continue;
            buff.append(c);
        }
        return buff.toString();
    }

    public static String[] concat(String[] a, String[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        String[] result = new String[a.length + b.length];
        int i = 0;
        for (String element : a) {
            result[i++] = element;
        }
        for (String element : b) {
            result[i++] = element;
        }
        return result;
    }

    public static String getLastStringAfterTheDelimiter(String stringData, char searchDelimiter) {
        return stringData.substring(stringData.lastIndexOf(searchDelimiter) + 1, stringData.length());
    }

    public static boolean equalsIgnoreWhiteSpace(String str1, String str2) {
        boolean result = false;
        char[] c1 = str1.trim().toCharArray();
        char[] c2 = str2.trim().toCharArray();
        int c1Length = c1.length;
        int c2Length = c2.length;
        int c1i = 0;
        for (int c2i = 0; c1i < c1Length && c2i < c2Length; ++c1i, ++c2i) {
            while (c1i < c1Length && Character.isWhitespace(c1[c1i])) {
                ++c1i;
            }
            while (c2i < c2Length && Character.isWhitespace(c2[c2i])) {
                ++c2i;
            }
            if (c1i == c1Length - 1 && c2i == c2Length - 1) {
                result = true;
            }
            if (c1[c1i] != c2[c2i]) break;
        }
        return result;
    }

    public static String splitAndSortsubStrings(String stringToSort, String splitterExp) {
        Object[] list = stringToSort.split(splitterExp);
        Arrays.sort(list);
        StringBuilder sbuff = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                sbuff.append(splitterExp);
            }
            sbuff.append((String)list[i]);
        }
        return sbuff.toString();
    }

    public static String splitAndSortsubStrings(String stringToSort, String splitterExp, String innerSplitter) {
        Object[] list = stringToSort.split(splitterExp);
        Arrays.sort(list);
        StringBuilder sbuff = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                sbuff.append(splitterExp);
            }
            sbuff.append(StringUtil.splitAndSortsubStrings((String)list[i], innerSplitter));
        }
        return sbuff.toString();
    }

    public static String encodeStringInBase64(String stringToEncode) {
        byte[] bytesEncoded = Base64.encodeBase64((byte[])stringToEncode.getBytes());
        return new String(bytesEncoded);
    }

    public static String compressAndEncodeStringInBase64(String stringToCompressAndEncode) throws IOException {
        ByteArrayOutputStream rstBao = new ByteArrayOutputStream();
        GZIPOutputStream zos = new GZIPOutputStream(rstBao);
        zos.write(stringToCompressAndEncode.getBytes());
        zos.close();
        byte[] bytes = rstBao.toByteArray();
        return Base64.encodeBase64String((byte[])bytes);
    }
}

