/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.clinicaldata;

import gov.va.med.cds.template.generated.allergies.AllergyAssessment;
import gov.va.med.cds.template.generated.allergies.IntoleranceCondition;
import gov.va.med.cds.template.generated.clinicaldata.Patients;
import gov.va.med.cds.template.generated.generichl7.GenericHl7DataEvent;
import gov.va.med.cds.template.generated.lab.LabTestPromise;
import gov.va.med.cds.template.generated.pgd.PatientGeneratedDataEvent;
import gov.va.med.cds.template.generated.pharmacy.OutpatientMedicationPromise;
import gov.va.med.cds.template.generated.surveys.ADLSurveyResponse;
import gov.va.med.cds.template.generated.surveys.DMPSurveyResponse;
import gov.va.med.cds.template.generated.surveys.PSSurveyResponse;
import gov.va.med.cds.template.generated.vitalsigns.VitalSignObservationEvent;
import java.util.List;
import org.dom4j.Element;

public enum DomainEntryPoint {
    ADLSurveyResponse("ADLSurveyResponse", "SURVEY", "adlSurveyResponse", ADLSurveyResponse.class),
    PSSurveyResponse("PSSurveyResponse", "SURVEY", "psSurveyResponse", PSSurveyResponse.class),
    DMPSurveyResponse("DMPSurveyResponse", "SURVEY", "dmpSurveyResponse", DMPSurveyResponse.class),
    CensusSurveyResponse("CensusSurveyResponse", "SURVEY", "censusSurveyResponse", Patients.class),
    VitalSignObservationEvent("VitalSignObservationEvent", "VITAL", "vitalSignObservationEvents", VitalSignObservationEvent.class),
    IntoleranceCondition("IntoleranceCondition", "ALLERGY", "intoleranceConditions", IntoleranceCondition.class),
    AllergyAssessment("AllergyAssessment", "ALLERGY", "allergyAssessments", AllergyAssessment.class),
    OutpatientMedicationPromise("OutpatientMedicationPromise", "PHARMACY", "outpatientMedicationPromises", OutpatientMedicationPromise.class),
    LabTestPromise("LabTestPromise", "LAB", "labTestPromises", LabTestPromise.class),
    NonVaMedicationEvent("NonVaMedicationEvent", "NONVAMED", "nonVaMedicationEvent"),
    ClinicalDocumentEvent("ClinicalDocumentEvent", "TIU", "clinicalDocumentEvents"),
    ImmunizationEvent("ImmunizationEvent", "IMMUNIZATION", "immunizationEvents"),
    SkinTestProcedure("SkinTestProcedure", "SKINTEST", "skinTestProcedures"),
    HealthConcern("HealthConcern", "PROBLEMLIST", "healthConcern"),
    ExamRequest2507("ExamRequest2507", "EXAMREQUEST", "examRequests"),
    Exam2507("Exam2507", "EXAM", "exams"),
    Appointment("Appointment", "Appointment", "appointments"),
    AppointmentLetter("AppointmentLetter", "AppointmentLetter", "appointmentLetters"),
    PatientDataAccessedEvent("PatientDataAccessedEvent", "PatientDataAccessedEvent", "patientDataAccessedEvents"),
    Demographic("Demographic", "Demographic", "demographics"),
    ReleaseOfInformation("ReleaseOfInformation", "ReleaseOfInformation", "releasesOfInformation"),
    ClinicalReminder("ClinicalReminder", "ClinicalReminder", "clinicalReminders"),
    PatientAlert("PatientAlert", "PatientAlert", "patientAlerts"),
    PatientEnteredVitalSign("PatientEnteredVitalSign", "VITAL", "patientEnteredVitalSigns", "patientEnteredVitalSign"),
    PatientEnteredExerciseJournalEntry("PatientEnteredExerciseJournalEntry", "EXCERCISEJOURNAL", "patientJournalEntries", "patientEnteredExerciseJournalEntry"),
    PatientEnteredDietJournalEntry("PatientEnteredDietJournalEntry", "DIETJOURNAL", "patientJournalEntries", "patientEnteredDietJournalEntry"),
    PatientEnteredContactLogJournalEntry("PatientEnteredContactLogJournalEntry", "CONTACTLOGJOURNAL", "patientJournalEntries", "patientEnteredContactLogJournalEntry"),
    PatientEnteredDailyEventJournalEntry("PatientEnteredDailyEventJournalEntry", "DAILYEVENTJOURNAL", "patientJournalEntries", "patientEnteredDailyEventJournalEntry"),
    PatientEnteredMoodJournalEntry("PatientEnteredMoodJournalEntry", "MOODJOURNAL", "patientJournalEntries", "patientEnteredMoodJournalEntry"),
    CalendarEvent("CalendarEvent", "CALENDAREVENT", "calendarEvents", "calendarEvent"),
    QuestionnaireResult("QuestionnaireResult", "QUESTIONNAIRERESULT", "questionnaireResults", "questionnaireResult"),
    GoalTracking("GoalTracking", "GOALTRACKING", "goalsTracking", "goalTracking"),
    SkillTracking("SkillTracking", "SKILLTRACKING", "skillsTracking", "skillTracking"),
    PainEvent("PainEvent", "PAINEVENT", "painEvents", "painEvent"),
    PainReassessment("PainReassessment", "PAINREASSESMENT", "painReassessments", "painReassessment"),
    PainAssessment("PainAssessment", "PAINASSESSMENT", "painAssessments", "painAssessment"),
    AssessmentDocument("AssessmentDocument", "ASSESSMENTDOCUMENT", "assessmentDocuments", "assessmentDocument"),
    SmartFormDocument("SmartFormDocument", "SMARTFORMDOCUMENT", "smartFormDocuments", "smartFormDocument"),
    GenericObservation("GenericObservation", "GENERICOBSERVATION", "genericObservations", "genericObservation"),
    PatientGeneratedDataEvent("PatientGeneratedDataEvent", "PGD", "patientGeneratedDataEvents", "patientGeneratedDataEvent", PatientGeneratedDataEvent.class),
    GenericHl7DataEvent("GenericHl7DataEvent", "HL7", "genericHl7DataEvents", "genericHl7DataEvent", GenericHl7DataEvent.class),
    VistaUser("VistaUser", "VISTAUSER", "vistaUsers", "vistaUser");

    private String name;
    private String domain;
    private String entityName;
    private String clinicalDataElement;
    private Class<?> templateUnmarshalClass;
    public static final String DOMAIN_ENTRY_POINT_PROPERTY_NAME = "DomainEntryPoints";

    private DomainEntryPoint(String aName, String aDomain, String entityName) {
        this.name = aName;
        this.domain = aDomain;
        this.entityName = entityName;
    }

    private DomainEntryPoint(String aName, String aDomain, String entityName, String clinicalDataElement) {
        this.name = aName;
        this.domain = aDomain;
        this.entityName = entityName;
        this.clinicalDataElement = clinicalDataElement;
    }

    private DomainEntryPoint(String aName, String aDomain, String entityName, Class<?> templateUnmarshalClass) {
        this.name = aName;
        this.domain = aDomain;
        this.entityName = entityName;
        this.setTemplateUnmarshalClass(templateUnmarshalClass);
    }

    private DomainEntryPoint(String aName, String aDomain, String entityName, String clinicalDataElement, Class<?> templateUnmarshalClass) {
        this.name = aName;
        this.domain = aDomain;
        this.entityName = entityName;
        this.clinicalDataElement = clinicalDataElement;
        this.setTemplateUnmarshalClass(templateUnmarshalClass);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getClinicalDataElement() {
        return this.clinicalDataElement;
    }

    public void setClinicalDataElement(String clinicalDataElement) {
        this.clinicalDataElement = clinicalDataElement;
    }

    public List<Element> getClinicalRecords(Element rootElement) {
        Element wrapperElement;
        List clinicalRecords = null;
        clinicalRecords = this.clinicalDataElement != null ? ((wrapperElement = rootElement.element(this.entityName)) != null ? wrapperElement.elements(this.clinicalDataElement) : null) : rootElement.elements(this.entityName);
        return clinicalRecords;
    }

    public Class<?> getTemplateUnmarshalClass() {
        return this.templateUnmarshalClass;
    }

    public void setTemplateUnmarshalClass(Class<?> templateUnmarshalClass) {
        this.templateUnmarshalClass = templateUnmarshalClass;
    }
}

