/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.client.proxy;

import gov.va.med.cds.client.proxy.IBlockingConnectionFactory;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.SocketClientException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.transport.socket.SocketConnector;

public class BlockingConnectionFactory
implements IBlockingConnectionFactory {
    private static Log logger = LogFactory.getLog(BlockingConnectionFactory.class);
    private int connectionTimeoutMillis;
    private int readTimeoutMillis;
    private int idleTimeoutMillis;
    SocketConnector socketConnector = null;

    public void setSocketConnector(SocketConnector socketConnector) {
        this.socketConnector = socketConnector;
    }

    @Override
    public SocketChannel getConnection(String host, int port) {
        SocketChannel socketChannel = null;
        InetAddress inetAddress = null;
        InetSocketAddress inetSocketAddress = null;
        try {
            inetAddress = InetAddress.getByName(host.trim());
            inetSocketAddress = new InetSocketAddress(inetAddress, port);
            socketChannel = SocketChannel.open();
            socketChannel.socket().setSoTimeout(this.readTimeoutMillis);
            socketChannel.socket().setSoLinger(false, this.idleTimeoutMillis);
            socketChannel.socket().setTcpNoDelay(false);
            socketChannel.connect(inetSocketAddress);
        }
        catch (UnknownHostException e1) {
            logger.error((Object)"Unknown host specified", (Throwable)e1);
            throw new SocketClientException(ErrorCodeEnum.SOCKET_CLIENT_UNKNOWN_HOST_EXCEPTION, (Throwable)e1);
        }
        catch (Exception e) {
            logger.error((Object)"Socket timeout exception occurred", (Throwable)e);
            throw new SocketClientException(ErrorCodeEnum.SOCKET_CLIENT_IO_EXCEPTION, (Throwable)e);
        }
        return socketChannel;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public void setIdleTimeoutMillis(int idleTimeoutMillis) {
        this.idleTimeoutMillis = idleTimeoutMillis;
    }
}

