/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.audit.persistence.jms;

import gov.va.med.cds.audit.AbstractAuditLog;
import gov.va.med.cds.audit.persistence.AuditLogPersistenceManagerInterface;
import gov.va.med.cds.util.LogMessageUtil;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class JmsAuditLogPersistenceManager
implements AuditLogPersistenceManagerInterface {
    private static final Log logger = LogFactory.getLog(JmsAuditLogPersistenceManager.class);
    private JmsTemplate readMessagesAuditJmsTemplate = null;
    private String appName;

    @Override
    public void storeAuditLog(final AbstractAuditLog auditLog) {
        try {
            this.readMessagesAuditJmsTemplate.send(new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    ObjectMessage objectMessage = session.createObjectMessage();
                    objectMessage.setObject((Serializable)auditLog);
                    return objectMessage;
                }
            });
        }
        catch (Exception exception) {
            logger.error((Object)LogMessageUtil.buildMessage(null, null, this.appName, "Error Auditing READ request message. "), (Throwable)exception);
        }
    }

    @Autowired
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Resource
    public void setReadMessagesAuditJmsTemplate(JmsTemplate readMessagesAuditJmsTemplate) {
        this.readMessagesAuditJmsTemplate = readMessagesAuditJmsTemplate;
    }
}

