/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.audit.persistence.hibernate;

import gov.va.med.cds.audit.TemplateIdWrapper;
import gov.va.med.cds.audit.persistence.CdsAuditClobStore;
import gov.va.med.cds.audit.persistence.CdsAuditClobStoreInterface;
import gov.va.med.cds.audit.persistence.HaAuditClobStore;
import gov.va.med.cds.audit.persistence.PathwaysAuditClobStore;
import java.util.List;
import org.springframework.orm.hibernate4.HibernateOperations;

public class PersistAuditStore
implements CdsAuditClobStoreInterface {
    private HibernateOperations hibernateOperations;

    @Override
    public void persistCdsAuditClob(CdsAuditClobStore cdsAuditClob) {
        this.persistTemplateIdWrapper(cdsAuditClob);
        this.hibernateOperations.save((Object)cdsAuditClob);
    }

    @Override
    public void persistHaAuditClob(HaAuditClobStore haAuditClob) {
        this.persistTemplateIdWrapper(haAuditClob);
        this.hibernateOperations.save((Object)haAuditClob);
    }

    @Override
    public void persistPathwaysAuditClob(PathwaysAuditClobStore pathwaysAuditClobStore) {
        this.persistTemplateIdWrapper(pathwaysAuditClobStore);
        this.hibernateOperations.save((Object)pathwaysAuditClobStore);
    }

    private void persistTemplateIdWrapper(PathwaysAuditClobStore pathwaysAuditClobStore) {
        List hibernateTemplateIds = this.hibernateOperations.findByExample((Object)pathwaysAuditClobStore.getTemplateIdWrapper());
        if (hibernateTemplateIds.size() < 1) {
            this.hibernateOperations.save((Object)pathwaysAuditClobStore.getTemplateIdWrapper());
        } else {
            pathwaysAuditClobStore.setTemplateIdWrapper((TemplateIdWrapper)hibernateTemplateIds.get(0));
        }
    }

    private void persistTemplateIdWrapper(CdsAuditClobStore cdsAuditClob) {
        List hibernateTemplateIds = this.hibernateOperations.findByExample((Object)cdsAuditClob.getTemplateIdWrapper());
        if (hibernateTemplateIds.size() < 1) {
            this.hibernateOperations.save((Object)cdsAuditClob.getTemplateIdWrapper());
        } else {
            cdsAuditClob.setTemplateIdWrapper((TemplateIdWrapper)hibernateTemplateIds.get(0));
        }
    }

    private void persistTemplateIdWrapper(HaAuditClobStore haAuditClob) {
        List hibernateTemplateIds = this.hibernateOperations.findByExample((Object)haAuditClob.getTemplateIdWrapper());
        if (hibernateTemplateIds.size() < 1) {
            this.hibernateOperations.save((Object)haAuditClob.getTemplateIdWrapper());
        } else {
            haAuditClob.setTemplateIdWrapper((TemplateIdWrapper)hibernateTemplateIds.get(0));
        }
    }

    public void setHibernateTemplate(HibernateOperations hibernateOperations) {
        this.hibernateOperations = hibernateOperations;
    }
}

