/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.audit;

import gov.va.med.cds.audit.AbstractAuditLog;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class VhimReadResponseAuditLog
extends AbstractAuditLog {
    private static final long serialVersionUID = 1L;

    @Override
    protected int getResponseLength(String response) {
        int responseLength = 0;
        if (response == null) {
            return responseLength;
        }
        try {
            Document document = DocumentHelper.parseText((String)response);
            Element rootElement = document.getRootElement();
            Iterator patientIterator = rootElement.elementIterator("patient");
            while (patientIterator.hasNext()) {
                Element patientElement = (Element)patientIterator.next();
                responseLength += patientElement.elements("allergyAssessments").size();
                responseLength += patientElement.elements("intoleranceConditions").size();
                responseLength += patientElement.elements("vitalSignObservationEvents").size();
                responseLength += patientElement.elements("outpatientMedicationPromises").size();
                responseLength += patientElement.elements("labTestPromises").size();
            }
            if (rootElement.element("patients") != null) {
                HashMap<String, String> namespaceUris = new HashMap<String, String>();
                namespaceUris.put("patientjournaling", "PatientJournaling");
                Iterator patientIterator2 = rootElement.element("patients").elementIterator("patient");
                while (patientIterator2.hasNext()) {
                    Element patientElement = (Element)patientIterator2.next();
                    responseLength += patientElement.selectNodes("clinicalDocumentEvents/clinicalDocumentEvent").size();
                    responseLength += patientElement.selectNodes("nonVaMedicationEvents/nonVaMedicationEvent").size();
                    responseLength += patientElement.selectNodes("skinTestProcedures/skinTestProcedure").size();
                    responseLength += patientElement.selectNodes("immunizationEvents/immunizationEvent").size();
                    responseLength += patientElement.selectNodes("healthConcerns/healthConcern").size();
                    responseLength += patientElement.selectNodes("outpatientMedicationPromises/outpatientMedicationPromise").size();
                    responseLength += patientElement.selectNodes("labTestPromises/labTestPromise").size();
                    responseLength += patientElement.selectNodes("patientEnteredVitalSigns/patientEnteredVitalSign").size();
                    responseLength += patientElement.selectNodes("calendarEvents/calendarEvent").size();
                    responseLength += patientElement.selectNodes("skillsTracking/skillTracking").size();
                    responseLength += patientElement.selectNodes("goalsTracking/goalTracking").size();
                    responseLength += patientElement.selectNodes("painEvents/painEvent").size();
                    responseLength += patientElement.selectNodes("painReassessments/painReassessment").size();
                    responseLength += patientElement.selectNodes("painAssessments/painAssessment").size();
                    responseLength += patientElement.selectNodes("assessmentDocuments/assessmentDocument").size();
                    responseLength += patientElement.selectNodes("questionnaireResults/questionnaireResult").size();
                    responseLength += patientElement.selectNodes("smartFormDocuments/smartFormDocument").size();
                    responseLength += this.getVPRCount(patientElement);
                }
            }
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("Invalid document string passed in.", e);
        }
        return responseLength;
    }

    private int getVPRCount(Element patientElement) throws DocumentException {
        JSONParser jsonParser = null;
        JSONObject dataObj = null;
        JSONObject innerObj = null;
        JSONObject response = null;
        int recordCnt = 0;
        List genericObsrvations = patientElement.selectNodes("genericObservations/genericObservation/observationValue");
        if (genericObsrvations != null && genericObsrvations.size() > 0) {
            for (Element el : genericObsrvations) {
                String vprResult = el.getText();
                if (vprResult.startsWith("<")) {
                    Document vprXml = DocumentHelper.parseText((String)vprResult);
                    Element e = (Element)vprXml.selectSingleNode("//radiologyExams");
                    if (null == e) {
                        e = (Element)vprXml.selectSingleNode("//flags");
                    }
                    recordCnt += Integer.parseInt(e.attributeValue("total"));
                    continue;
                }
                jsonParser = new JSONParser(-1);
                try {
                    response = (JSONObject)jsonParser.parse(vprResult);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Invalid json string passed in.", e);
                }
                dataObj = (JSONObject)response.get((Object)"data");
                if (dataObj != null) {
                    recordCnt += ((Integer)dataObj.get((Object)"totalItems")).intValue();
                    continue;
                }
                dataObj = (JSONObject)response.get((Object)"results");
                if (dataObj == null) continue;
                innerObj = (JSONObject)dataObj.get((Object)"radiologyExams");
                if (null == innerObj) {
                    innerObj = (JSONObject)dataObj.get((Object)"flags");
                }
                recordCnt += ((Integer)innerObj.get((Object)"total")).intValue();
            }
        }
        return recordCnt;
    }
}

