/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.tfs.tfdm;

import gov.va.med.tfs.tfdm.DomainEntryPoint;
import gov.va.med.tfs.tfdm.TemplateMetaDataInterface;
import gov.va.med.tfs.tfdm.VhimVersionWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.engine.jdbc.NonContextualLobCreator;

public class TemplateMetaData
implements TemplateMetaDataInterface,
Serializable {
    private static final long serialVersionUID = 414300865982739266L;
    private Set<DomainEntryPoint> domainEntryPoints;
    private Set<String> vhimVersions;
    private String cdsVdm;
    private HashSet<String> readCdsVdms;
    private String templateName;
    private String templateDescription;
    private String operation;
    private boolean testOnly;
    private String templateId;
    private Date dateAdded;
    private Date dateDeprecated;
    private Date dateActivated;
    private Date dateDeactivated;
    private Date dateUpdated;
    private String status;
    private byte[] templateJar;
    private Set<VhimVersionWrapper> vhimVersionWrappers = null;

    @Override
    public Set<DomainEntryPoint> getDomainEntryPoints() {
        return this.domainEntryPoints;
    }

    @Override
    public void setDomainEntryPoints(Set<DomainEntryPoint> theDomainEntryPoints) {
        this.domainEntryPoints = theDomainEntryPoints;
    }

    @Override
    public String getWriteCdsVdm() {
        return this.cdsVdm;
    }

    @Override
    public void setWriteCdsVdm(String aCdsVdm) {
        this.cdsVdm = aCdsVdm;
    }

    @Override
    public HashSet<String> getReadCdsVdms() {
        if (this.readCdsVdms == null) {
            this.readCdsVdms = new HashSet();
        }
        return this.readCdsVdms;
    }

    @Override
    public void setReadCdsVdms(HashSet<String> aCdsVdms) {
        this.readCdsVdms = aCdsVdms;
    }

    @Override
    public Set<String> getVhimVersions() {
        return this.vhimVersions;
    }

    @Override
    public void setVhimVersions(Set<String> aVhimVersions) {
        this.vhimVersions = aVhimVersions;
    }

    @Override
    public Set<VhimVersionWrapper> getVhimVersionWrappers() {
        if (this.vhimVersionWrappers == null && this.vhimVersions != null) {
            this.vhimVersionWrappers = new HashSet<VhimVersionWrapper>(this.vhimVersions.size());
            for (String vhimVersion : this.vhimVersions) {
                VhimVersionWrapper vvw = new VhimVersionWrapper();
                vvw.setVersion(vhimVersion);
                this.vhimVersionWrappers.add(vvw);
            }
        }
        return this.vhimVersionWrappers;
    }

    @Override
    public void setVhimVersionWrappers(Set<VhimVersionWrapper> aVhimVersions) {
        this.vhimVersionWrappers = aVhimVersions;
        if (this.vhimVersions == null && aVhimVersions != null) {
            this.vhimVersions = new HashSet<String>(aVhimVersions.size());
            for (VhimVersionWrapper vhimVersionWrapper : aVhimVersions) {
                this.vhimVersions.add(vhimVersionWrapper.getVersion());
            }
        }
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    @Override
    public void setTemplateId(String theTemplateId) {
        this.templateId = theTemplateId;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public void setTemplateName(String theTemplateName) {
        this.templateName = theTemplateName;
    }

    @Override
    public String getTemplateDescription() {
        return this.templateDescription;
    }

    @Override
    public void setTemplateDescription(String theTemplateDescription) {
        this.templateDescription = theTemplateDescription;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public void setOperation(String theOperation) {
        this.operation = theOperation;
    }

    @Override
    public boolean getTestOnly() {
        return this.testOnly;
    }

    @Override
    public void setTestOnly(boolean aTestOnly) {
        this.testOnly = aTestOnly;
    }

    @Override
    public void setTestOnly(String aTrueOrFalse) {
        this.testOnly = Boolean.parseBoolean(aTrueOrFalse);
    }

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public void setDateAdded(Date dateAdded) {
        this.dateAdded = dateAdded;
    }

    public Date getDateDeprecated() {
        return this.dateDeprecated;
    }

    public void setDateDeprecated(Date dateDeprecated) {
        this.dateDeprecated = dateDeprecated;
    }

    public Date getDateActivated() {
        return this.dateActivated;
    }

    public void setDateActivated(Date dateActivated) {
        this.dateActivated = dateActivated;
    }

    public Date getDateDeactivated() {
        return this.dateDeactivated;
    }

    public void setDateDeactivated(Date dateDeactivated) {
        this.dateDeactivated = dateDeactivated;
    }

    public Date getDateUpdated() {
        return this.dateUpdated;
    }

    public void setDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTemplateJar(byte[] jar) {
        this.templateJar = jar;
    }

    public byte[] getTemplateJar() {
        return this.templateJar;
    }

    private void setBlob(Blob jar) {
        this.templateJar = this.toByteArray(jar);
    }

    private Blob getBlob() {
        return this.createBlob(this.templateJar);
    }

    private Blob createBlob(byte[] bytes) {
        Blob blob = null;
        blob = NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createBlob(bytes));
        return blob;
    }

    private byte[] toByteArray(Blob fromJar) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            return this.toByteArrayImpl(fromJar, baos);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toByteArrayImpl(Blob fromJar, ByteArrayOutputStream baos) throws SQLException, IOException {
        byte[] buf = new byte[4000];
        try (InputStream is = fromJar.getBinaryStream();){
            int dataSize;
            while ((dataSize = is.read(buf)) != -1) {
                baos.write(buf, 0, dataSize);
            }
        }
        return baos.toByteArray();
    }

    public String toString() {
        return "id: " + this.getTemplateId() + ", name: " + this.getTemplateName() + ", desc: " + this.getTemplateDescription() + ", dateAdded: " + this.dateAdded + ", status: " + this.status + ", vhims: " + this.getVhimVersions() + ", domainEntryPoints: " + this.getDomainEntryPoints() + "\nBLOB size: " + this.getTemplateJar().length + ", value: " + this.getTemplateJar();
    }
}

