/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.tfs.persistence.hibernate;

import gov.va.med.tfs.persistence.CreateTemplatePersistenceManagerInterface;
import gov.va.med.tfs.persistence.hibernate.AbstractTfsHibernatePersistenceManager;
import gov.va.med.tfs.tfdm.TemplateMetaData;
import gov.va.med.tfs.tfdm.TemplateMetaDataInterface;
import org.hibernate.Query;
import org.hibernate.Session;

public class CreatableHibernateTemplatePersistenceManager
extends AbstractTfsHibernatePersistenceManager
implements CreateTemplatePersistenceManagerInterface {
    private String PERSIST_SUCCESSFUL = "Sucessfully Persisted Template - Thank You";
    private String RECORD_EXISTS = "Record already exists -- Template Not Persisted";
    private String PERSISTING_RECORD = "Persisting Record";

    @Override
    public final String createTemplateData(TemplateMetaDataInterface aTemplateMetaData) throws Exception {
        Session session = this.sessionFactory.openSession();
        String persistReturn = this.PERSISTING_RECORD;
        this.persistifyVhimVersions(session, aTemplateMetaData.getVhimVersionWrappers());
        this.persistifyDomainEntryPoints(session, aTemplateMetaData.getDomainEntryPoints());
        persistReturn = this.persistifyTemplate(session, aTemplateMetaData);
        if (persistReturn.equals(this.PERSIST_SUCCESSFUL)) {
            session.flush();
        }
        session.close();
        return persistReturn;
    }

    private String persistifyTemplate(Session aSession, TemplateMetaDataInterface aTemplateMetaData) {
        TemplateMetaData queryResult = null;
        String persistifyTemplateReturn = this.RECORD_EXISTS;
        Query query = aSession.getNamedQuery("TemplateSchemaId").setParameter("templateId", (Object)aTemplateMetaData.getTemplateId());
        queryResult = (TemplateMetaData)query.uniqueResult();
        if (queryResult == null) {
            aSession.save((Object)aTemplateMetaData);
            persistifyTemplateReturn = this.PERSIST_SUCCESSFUL;
        }
        return persistifyTemplateReturn;
    }
}

