/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.tfs.persistence.hibernate;

import gov.va.med.tfs.persistence.CreateFilterPersistenceManagerInterface;
import gov.va.med.tfs.persistence.hibernate.AbstractTfsHibernatePersistenceManager;
import gov.va.med.tfs.tfdm.EntryFilter;
import gov.va.med.tfs.tfdm.FilterMetaData;
import gov.va.med.tfs.tfdm.FilterMetaDataInterface;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class CreatableHibernateFilterPersistenceManager
extends AbstractTfsHibernatePersistenceManager
implements CreateFilterPersistenceManagerInterface {
    private String PERSIST_SUCCESSFUL = "Sucessfully Persisted Filter - Thank You";
    private String RECORD_EXISTS = "Record already exists -- Filter Not Persisted";
    private String PERSISTING_RECORD = "Persisting Record";

    private String persistFilterSchema(FilterMetaDataInterface filterMetaData, Session aSession) throws Exception {
        String persistReturn = this.PERSISTING_RECORD;
        this.persistifyVhimVersions(aSession, filterMetaData.getVhimVersionWrappers());
        this.persistifyEntryFilters(aSession, filterMetaData.getEntryFilters());
        persistReturn = this.persistifyFilter(aSession, filterMetaData);
        if (persistReturn.equals(this.PERSIST_SUCCESSFUL)) {
            aSession.flush();
        }
        aSession.close();
        return persistReturn;
    }

    private void persistifyEntryFilters(Session aSession, Set<EntryFilter> entryFilters) {
        EntryFilter[] entryFiltersArray = entryFilters.toArray(new EntryFilter[0]);
        EntryFilter queryResult = null;
        for (EntryFilter entryFilter : entryFiltersArray) {
            entryFilter.setDomainEntryPoint(this.persistifyDomainEntryPoint(aSession, entryFilter.getDomainEntryPoint()));
            Query query = entryFilter.getXpath() != null ? aSession.getNamedQuery("EntryFilterDomainXpath").setParameter("xpath", (Object)entryFilter.getXpath()).setParameter("depw", (Object)entryFilter.getDomainEntryPoint()) : aSession.getNamedQuery("EntryFilterDomainNullXpath").setParameter("depw", (Object)entryFilter.getDomainEntryPoint());
            queryResult = (EntryFilter)query.uniqueResult();
            if (queryResult == null) continue;
            entryFilters.remove(entryFilter);
            entryFilters.add(queryResult);
        }
    }

    private String persistifyFilter(Session aSession, FilterMetaDataInterface aFilterMetaData) {
        FilterMetaData queryResult = null;
        String persistifyFilterReturn = this.RECORD_EXISTS;
        Query query = aSession.getNamedQuery("FilterSchemaId").setParameter("filterId", (Object)aFilterMetaData.getFilterId());
        queryResult = (FilterMetaData)query.uniqueResult();
        if (queryResult == null) {
            aSession.save((Object)aFilterMetaData);
            persistifyFilterReturn = this.PERSIST_SUCCESSFUL;
        }
        return persistifyFilterReturn;
    }

    @Override
    public String createFilterData(FilterMetaDataInterface aFilterMetaData) throws Exception {
        Session session = this.sessionFactory.openSession();
        return this.persistFilterSchema(aFilterMetaData, session);
    }
}

