/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.monitor.util;

import gov.va.med.cds.monitor.util.MBeanConnection;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanConnectionUtil {
    public static final String DISABLE = "disable";
    public static final String ENABLE = "enable";

    public static void enableDisableMBeanConnection(String enableCommand, String server, String port, String principal, String credentials, String beanKeyName) throws Exception {
        MBeanConnection mbeanConnection = MBeanConnectionUtil.getMBeanConnection(server, port, principal, credentials, beanKeyName);
        MBeanServerConnection connection = mbeanConnection.getConnection();
        ObjectName on = mbeanConnection.getService();
        if (ENABLE.equalsIgnoreCase(enableCommand)) {
            connection.invoke(on, "enableMetrics", null, null);
        } else if (DISABLE.equalsIgnoreCase(enableCommand)) {
            connection.invoke(on, "disableMetrics", null, null);
        }
        MBeanConnectionUtil.returnMBeanConnection(mbeanConnection);
    }

    public static MBeanConnection getMBeanConnection(String server, String port, String principal, String credentials, String beanKeyName) throws MalformedObjectNameException, MalformedURLException, IOException {
        MBeanConnection mbeanConnection = new MBeanConnection();
        mbeanConnection.initConnection(server, port, principal, credentials, beanKeyName);
        return mbeanConnection;
    }

    public static MBeanConnection getMBeanConnection(boolean managedServer, String server, String port, String principal, String credentials, String beanKeyName) throws MalformedObjectNameException, MalformedURLException, IOException {
        MBeanConnection mbeanConnection = new MBeanConnection();
        if (!managedServer) {
            mbeanConnection.initAdminConnection(server, port, principal, credentials, beanKeyName);
        } else {
            mbeanConnection.initConnection(server, port, principal, credentials, beanKeyName);
        }
        return mbeanConnection;
    }

    public static void returnMBeanConnection(MBeanConnection mbeanConnection) throws IOException {
        mbeanConnection.closeConnection();
    }

    public static Object getMBeanValue(String attribute, boolean managedServer, String server, String port, String principal, String credentials, String beanKeyName) throws Exception {
        MBeanConnection mbeanConnection = MBeanConnectionUtil.getMBeanConnection(managedServer, server, port, principal, credentials, beanKeyName);
        MBeanServerConnection connection = mbeanConnection.getConnection();
        ObjectName on = mbeanConnection.getService();
        Object returnValue = connection.getAttribute(on, attribute);
        MBeanConnectionUtil.returnMBeanConnection(mbeanConnection);
        return returnValue;
    }

    public static AttributeList getMBeanValues(String[] attributes, boolean managedServer, String server, String port, String principal, String credentials, String beanKeyName) throws Exception {
        MBeanConnection mbeanConnection = MBeanConnectionUtil.getMBeanConnection(managedServer, server, port, principal, credentials, beanKeyName);
        MBeanServerConnection connection = mbeanConnection.getConnection();
        ObjectName on = mbeanConnection.getService();
        AttributeList values = connection.getAttributes(on, attributes);
        MBeanConnectionUtil.returnMBeanConnection(mbeanConnection);
        return values;
    }
}

